/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.ArrayList;

public class SpreadSheetInsertColumn
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = 9030574317512531337L;
    protected SpreadSheetColumnIndex m_Position;
    protected boolean m_After;
    protected String m_Header;
    protected String m_Value;
    protected boolean m_ValueContainsPlaceholder;
    protected boolean m_ValueContainsVariable;
    protected boolean m_ForceString;

    public String globalInfo() {
        return "Inserts a column at a specific position into spreadsheets coming through.\nThe cells are initialized with a pre-defined value.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new SpreadSheetColumnIndex();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("after", "after", (Object)false);
        this.m_OptionManager.add("header", "header", (Object)"New");
        this.m_OptionManager.add("value", "value", (Object)"?");
        this.m_OptionManager.add("placeholder", "valueContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "valueContainsVariable", (Object)false);
        this.m_OptionManager.add("force-string", "forceString", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"header", (Object)("'" + this.m_Header + "'"), (String)"header: ");
        result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"after") ? result + ", at/after: " : (this.m_After ? result + ", after: " : result + ", at: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"position", (Object)((Object)this.m_Position));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)("'" + this.getValue() + "'"), (String)", insert: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"valueContainsPlaceholder", (boolean)this.m_ValueContainsPlaceholder, (String)"PH"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"valueContainsVariable", (boolean)this.m_ValueContainsVariable, (String)"Var"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"forceString", (boolean)this.m_ForceString, (String)"string"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setPosition(SpreadSheetColumnIndex value) {
        this.m_Position = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the column; " + this.m_Position.getExample();
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the column is inserted after the position instead of at the position.";
    }

    public void setHeader(String value) {
        this.m_Header = value;
        this.reset();
    }

    public String getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The name of the new column.";
    }

    public void setValue(String value) {
        this.m_Value = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getValue() {
        return Utils.backQuoteChars((String)this.m_Value);
    }

    public String valueTipText() {
        return "The value to intialize the cells with; you can use '\\t' for tab, '\\n' for line-feed and '\\r' for carriage-return.";
    }

    public void setValueContainsPlaceholder(boolean value) {
        this.m_ValueContainsPlaceholder = value;
        this.reset();
    }

    public boolean getValueContainsPlaceholder() {
        return this.m_ValueContainsPlaceholder;
    }

    public String valueContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the value string.";
    }

    public void setValueContainsVariable(boolean value) {
        this.m_ValueContainsVariable = value;
        this.reset();
    }

    public boolean getValueContainsVariable() {
        return this.m_ValueContainsVariable;
    }

    public String valueContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the value string.";
    }

    public void setForceString(boolean value) {
        this.m_ForceString = value;
        this.reset();
    }

    public boolean getForceString() {
        return this.m_ForceString;
    }

    public String forceStringTipText() {
        return "If enabled, the value is set as string, even if it resembles a number.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        String value = this.m_Value;
        if (this.m_ValueContainsVariable) {
            value = this.getVariables().expand(value);
        }
        if (this.m_ValueContainsPlaceholder) {
            value = Placeholders.getSingleton().expand(value);
        }
        int pos = 0;
        if (sheetOld.getColumnCount() > 0) {
            this.m_Position.setSpreadSheet(sheetOld);
            pos = this.m_Position.getIntIndex();
            if (this.m_After) {
                ++pos;
            }
        }
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        sheetNew.insertColumn(pos, this.m_Header, value);
        this.m_OutputToken = new Token((Object)sheetNew);
        return result;
    }
}

