/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.SpreadSheetMergeActor;
import adams.flow.transformer.spreadsheetmethodmerge.AbstractMerge;
import adams.flow.transformer.spreadsheetmethodmerge.Simple;

public class SpreadSheetMethodMerge
extends AbstractTransformer
implements SpreadSheetMergeActor {
    private static final long serialVersionUID = 3778575114133031631L;
    protected AbstractMerge m_MergeMethod;

    public String globalInfo() {
        return "Merges 2 or more spreadsheets into a single spreadsheet, using a selectable merge method.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("method", "mergeMethod", (Object)new Simple());
    }

    public AbstractMerge getMergeMethod() {
        return this.m_MergeMethod;
    }

    public void setMergeMethod(AbstractMerge mergeMethod) {
        this.m_MergeMethod = mergeMethod;
        this.reset();
    }

    public String mergeMethodTipText() {
        return "The method that should be used to perform the merge.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"mergeMethod", (Object)((Object)this.m_MergeMethod), (String)"method: ");
    }

    protected SpreadSheet[] getInput() {
        SpreadSheet[] datasets;
        Object payload = this.m_InputToken.getPayload();
        if (payload instanceof SpreadSheet[]) {
            datasets = (SpreadSheet[])payload;
        } else if (payload instanceof DataRow[]) {
            DataRow[] datarowPayload = (DataRow[])payload;
            datasets = new SpreadSheet[datarowPayload.length];
            for (int i = 0; i < datarowPayload.length; ++i) {
                datasets[i] = this.spreadsheetForSingleDatarow(datarowPayload[i]);
            }
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        return datasets;
    }

    protected SpreadSheet spreadsheetForSingleDatarow(DataRow row) {
        DefaultSpreadSheet dataset = new DefaultSpreadSheet();
        row.getClone((SpreadSheet)dataset);
        return dataset;
    }

    protected void setOutput(SpreadSheet output) {
        this.m_OutputToken = new Token();
        this.m_OutputToken.setPayload((Object)output);
    }

    protected String doExecute() {
        try {
            SpreadSheet[] spreadsheetsToMerge = this.getInput();
            SpreadSheet mergedSpreadsheet = this.m_MergeMethod.merge(spreadsheetsToMerge);
            this.setOutput(mergedSpreadsheet);
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet[].class, DataRow[].class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }
}

