/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUnorderedColumnRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetReorderColumns
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = -6140158624456525670L;
    protected SpreadSheetUnorderedColumnRange m_Order;

    public String globalInfo() {
        return "Reorders the columns in a spreadsheet according to a user-supplied order. Columns can be supplied either by name or index (1-based). Depending on whether you use a column multiple times or omit it, you effectively duplicate it or remove it from the final spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("order", "order", (Object)new SpreadSheetUnorderedColumnRange("first-last"));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"order", (Object)((Object)this.m_Order));
    }

    public void setOrder(SpreadSheetUnorderedColumnRange value) {
        this.m_Order = value;
        this.reset();
    }

    public SpreadSheetUnorderedColumnRange getOrder() {
        return this.m_Order;
    }

    public String orderTipText() {
        return "The new order for the columns";
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Order.isEmpty()) {
            result = "No new column order provided!";
        }
        if (result == null) {
            int i;
            SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
            SpreadSheet output = input.newInstance();
            output.setDataRowClass(input.getDataRowClass());
            for (String comment : input.getComments()) {
                output.addComment(comment);
            }
            this.m_Order.setData(input);
            int[] indices = this.m_Order.getIntIndices();
            HeaderRow rowOld = input.getHeaderRow();
            HeaderRow rowNew = output.getHeaderRow();
            for (i = 0; i < indices.length; ++i) {
                rowNew.addCell("" + i).setContentAsString(rowOld.getContent(indices[i]));
            }
            for (int n = 0; n < input.getRowCount(); ++n) {
                rowOld = input.getRow(n);
                rowNew = output.addRow();
                for (i = 0; i < indices.length; ++i) {
                    if (!rowOld.hasCell(indices[i])) continue;
                    rowNew.addCell("" + i).assign(rowOld.getCell(indices[i]));
                }
            }
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

