/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.binning.Bin;
import adams.data.binning.Binnable;
import adams.data.binning.algorithm.BinningAlgorithm;
import adams.data.binning.algorithm.BinningAlgorithmUser;
import adams.data.binning.algorithm.ManualBinning;
import adams.data.binning.operation.Wrapping;
import adams.data.binning.postprocessing.BinPostProcessing;
import adams.data.binning.postprocessing.BinPostProcessingUser;
import adams.data.binning.postprocessing.PassThrough;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.ArrayList;
import java.util.List;

public class SpreadSheetRowBinning
extends AbstractInPlaceSpreadSheetTransformer
implements BinningAlgorithmUser,
BinPostProcessingUser {
    private static final long serialVersionUID = -4140425415663734153L;
    protected SpreadSheetColumnIndex m_BinningColumn;
    protected BinningAlgorithm m_Algorithm;
    protected BinPostProcessing m_PostProcessing;
    protected SpreadSheetColumnIndex m_Position;
    protected boolean m_After;
    protected String m_Header;

    public String globalInfo() {
        return "Applies a binning algorithm to the values from the specified binning column to filter the rows into specific bins.\nA new column is then added containing the corresponding bin index.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("binning-column", "binningColumn", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("algorithm", "algorithm", (Object)new ManualBinning());
        this.m_OptionManager.add("post-processing", "postProcessing", (Object)new PassThrough());
        this.m_OptionManager.add("position", "position", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("after", "after", (Object)false);
        this.m_OptionManager.add("header", "header", (Object)"Bin");
    }

    public void setBinningColumn(SpreadSheetColumnIndex value) {
        this.m_BinningColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getBinningColumn() {
        return this.m_Position;
    }

    public String binningColumnTipText() {
        return "The column to obtain the numeric values from to use for binning.";
    }

    public void setAlgorithm(BinningAlgorithm value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public BinningAlgorithm getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The binning algorithm to apply.";
    }

    public void setPostProcessing(BinPostProcessing value) {
        this.m_PostProcessing = value;
        this.reset();
    }

    public BinPostProcessing getPostProcessing() {
        return this.m_PostProcessing;
    }

    public String postProcessingTipText() {
        return "The post-processing algorithm to apply to the bins.";
    }

    public void setPosition(SpreadSheetColumnIndex value) {
        this.m_Position = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the column; " + this.m_Position.getExample();
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the column is inserted after the position instead of at the position.";
    }

    public void setHeader(String value) {
        this.m_Header = value;
        this.reset();
    }

    public String getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The name of the new column.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"binningColumn", (Object)((Object)this.m_BinningColumn), (String)"binning: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)this.m_Algorithm, (String)", algorithm: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"postProcessing", (Object)this.m_PostProcessing, (String)", post: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"header", (Object)("'" + this.m_Header + "'"), (String)", header: ");
        result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"after") ? result + ", at/after: " : (this.m_After ? result + ", after: " : result + ", at: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"position", (Object)((Object)this.m_Position));
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        int binCol = 0;
        int pos = 0;
        if (sheetOld.getColumnCount() > 0) {
            this.m_BinningColumn.setData(sheetOld);
            binCol = this.m_BinningColumn.getIntIndex();
            this.m_Position.setSpreadSheet(sheetOld);
            pos = this.m_Position.getIntIndex();
            if (this.m_After) {
                ++pos;
            }
        }
        double[] values = SpreadSheetUtils.getNumericColumn((SpreadSheet)sheetOld, (int)binCol);
        List rows = null;
        try {
            rows = Wrapping.wrap((double[])values);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate binnable data!", e);
        }
        if (result == null) {
            List bins = this.m_Algorithm.generateBins(rows);
            bins = this.m_PostProcessing.postProcessBins(bins);
            sheetNew.insertColumn(pos, this.m_Header);
            for (Bin bin : bins) {
                for (Binnable object : bin.get()) {
                    int i = (Integer)object.getPayload();
                    DataRow row = sheetNew.getRow(i);
                    row.addCell(pos).setContent(Integer.valueOf(bin.getIndex()));
                }
            }
            this.m_OutputToken = new Token((Object)sheetNew);
        }
        return result;
    }
}

