/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetViewCreator;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import adams.data.spreadsheet.rowfinder.NullFinder;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetRowFilter
extends AbstractSpreadSheetTransformer
implements SpreadSheetViewCreator {
    private static final long serialVersionUID = 3754073511732133649L;
    protected RowFinder m_Finder;
    protected boolean m_CreateView;

    public String globalInfo() {
        return "Filters spreadsheets using the specified row finder.\nThe output contains all the rows that the specified finder selected.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new NullFinder());
        this.m_OptionManager.add("create-view", "createView", (Object)false);
    }

    public void setFinder(RowFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public RowFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The row finder to use for identifying rows for the output.";
    }

    @Override
    public void setCreateView(boolean value) {
        this.m_CreateView = value;
        this.reset();
    }

    @Override
    public boolean getCreateView() {
        return this.m_CreateView;
    }

    @Override
    public String createViewTipText() {
        return "If enabled, then only a view of the row subset is created.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"createView", (boolean)this.m_CreateView, (String)", view only");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet output = this.m_CreateView ? input.toView(this.m_Finder.findRows(input), null) : AbstractRowFinder.filter(input, this.m_Finder);
        this.m_OutputToken = new Token((Object)output);
        return result;
    }
}

