/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractRowStatistic;
import adams.data.spreadsheet.rowstatistic.Mean;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetRowStatistic
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 4527040722924866539L;
    protected Index m_Row;
    protected AbstractRowStatistic m_Statistic;

    public String globalInfo() {
        return "Generates statistics for a chosen row.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Index("first"));
        this.m_OptionManager.add("statistic", "statistic", (Object)new Mean());
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row to generate the statistics for.";
    }

    public void setStatistic(AbstractRowStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public AbstractRowStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The statistic to generate for the specified row.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)"row: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"statistic", (Object)((Object)this.m_Statistic), (String)", stat: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Row.setMax(input.getRowCount());
        int row = this.m_Row.getIntIndex();
        if (row == -1) {
            result = "Failed to locate row: " + this.m_Row;
        } else {
            SpreadSheet output = this.m_Statistic.generate(input, row);
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

