/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.MouseUtils;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheetpreview.AbstractSpreadSheetPreview;
import adams.gui.core.spreadsheetpreview.NullPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class SpreadSheetSelectSubset
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = -7861621358380784108L;
    protected String m_Message;
    protected boolean m_AllowSearch;
    protected SpreadSheetTable m_Table;
    protected JLabel m_LabelMessage;
    protected boolean m_MultiSelection;
    protected AbstractSpreadSheetPreview m_Preview;
    protected boolean m_Accepted;

    public String globalInfo() {
        return "Allows the user to select a subset of the incoming spreadsheet to be forwarded in the flow.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("message", "message", (Object)"Please make your selection");
        this.m_OptionManager.add("allow-search", "allowSearch", (Object)false);
        this.m_OptionManager.add("multi-selection", "multiSelection", (Object)true);
        this.m_OptionManager.add("preview", "preview", (Object)new NullPreview());
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"message", (Object)this.m_Message, (String)", message: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"allowSearch", (boolean)this.m_AllowSearch, (String)"searchable", (String)", ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"multiSelection", (Object)(this.m_MultiSelection ? "" : "single-selection"), (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    protected int getDefaultWidth() {
        return 600;
    }

    protected int getDefaultHeight() {
        return 400;
    }

    protected int getDefaultX() {
        return -2;
    }

    protected int getDefaultY() {
        return -2;
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to prompt the user with; variables get expanded prior to prompting user.";
    }

    public void setAllowSearch(boolean value) {
        this.m_AllowSearch = value;
        this.reset();
    }

    public boolean getAllowSearch() {
        return this.m_AllowSearch;
    }

    public String allowSearchTipText() {
        return "Whether to allow the user to search the list.";
    }

    public void setMultiSelection(boolean value) {
        this.m_MultiSelection = value;
        this.reset();
    }

    public boolean getMultiSelection() {
        return this.m_MultiSelection;
    }

    public String multiSelectionTipText() {
        return "Whether to allow the user to select multiple rows or just a single one.";
    }

    public void setPreview(AbstractSpreadSheetPreview value) {
        this.m_Preview = value;
        this.reset();
    }

    public AbstractSpreadSheetPreview getPreview() {
        return this.m_Preview;
    }

    public String previewTipText() {
        return "The preview to use for selected rows.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    public void clearPanel() {
        this.m_Table.setModel((TableModel)new SpreadSheetTableModel());
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        JPanel panelCenter = new JPanel(new BorderLayout());
        result.add((Component)panelCenter, (Object)"Center");
        this.m_Table = new SpreadSheetTable(new SpreadSheetTableModel());
        if (this.m_MultiSelection) {
            this.m_Table.getSelectionModel().setSelectionMode(2);
        } else {
            this.m_Table.getSelectionModel().setSelectionMode(0);
        }
        AbstractSpreadSheetPreview.AbstractSpreadSheetPreviewPanel previewPanel = this.m_Preview.generate();
        if (previewPanel == null) {
            panelCenter.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
        } else {
            BaseSplitPane splitPane = new BaseSplitPane(0);
            splitPane.setOneTouchExpandable(true);
            splitPane.setResizeWeight(1.0);
            splitPane.setTopComponent((Component)new BaseScrollPane((Component)this.m_Table));
            splitPane.setBottomComponent((Component)((Object)previewPanel));
            splitPane.setDividerLocation((int)((double)this.m_Height * 0.5));
            splitPane.setUISettingsParameters(SpreadSheetSelectSubset.class, "previewDividerLocation");
            panelCenter.add((Component)splitPane, "Center");
            this.m_Table.getSelectionModel().addListSelectionListener(e -> {
                int[] sel = this.m_Table.getSelectedRows();
                int[] rows = new int[sel.length];
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = this.m_Table.getActualRow(sel[i]);
                }
                previewPanel.preview(this.m_Table.toSpreadSheet(), rows);
            });
        }
        this.m_LabelMessage = new JLabel();
        JPanel panelMessage = new JPanel(new FlowLayout(0));
        panelMessage.add(this.m_LabelMessage);
        panelCenter.add((Component)panelMessage, "North");
        if (this.m_AllowSearch) {
            SearchPanel panelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false);
            panelSearch.addSearchListener(e -> this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
            panelCenter.add((Component)panelSearch, "South");
        }
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        result.add((Component)panelButtons, (Object)"South");
        final BaseButton buttonOK = new BaseButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(e -> {
            this.m_Accepted = true;
            this.m_Dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonCancel = new BaseButton("Cancel");
        buttonCancel.setMnemonic('C');
        buttonCancel.addActionListener(e -> {
            this.m_Accepted = false;
            this.m_Dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonCancel);
        this.m_Table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && SpreadSheetSelectSubset.this.m_Table.getSelectedRowCount() > 0) {
                    buttonOK.doClick();
                }
                if (!e.isConsumed()) {
                    super.mouseClicked(e);
                }
            }
        });
        return result;
    }

    public boolean doInteract() {
        this.m_LabelMessage.setText(this.getVariables().expand(this.m_Message));
        this.m_Table.setModel((TableModel)new SpreadSheetTableModel((SpreadSheet)this.m_InputToken.getPayload()));
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        this.m_Accepted = false;
        this.m_Dialog.setVisible(true);
        this.deregisterWindow((Window)this.m_Dialog);
        if (this.m_Accepted) {
            SpreadSheet selected = this.m_Table.toSpreadSheet(TableRowRange.SELECTED);
            this.m_OutputToken = new Token((Object)selected);
        }
        return this.m_Accepted;
    }
}

