/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.spreadsheetmethodmerge;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.spreadsheetmethodmerge.AbstractMerge;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JoinOnID
extends AbstractMerge {
    private static final long serialVersionUID = -481246610037807743L;
    protected String m_UniqueID;
    protected boolean m_CompleteRowsOnly;

    public String globalInfo() {
        return "Joins the spreadsheets by concatenating rows that share a unique ID.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("unique-id", "uniqueID", (Object)"");
        this.m_OptionManager.add("complete-rows-only", "completeRowsOnly", (Object)false);
    }

    public String getUniqueID() {
        return this.m_UniqueID;
    }

    public void setUniqueID(String value) {
        this.m_UniqueID = value;
        this.reset();
    }

    public String uniqueIDTipText() {
        return "The name of the column to use as the joining key for the merge.";
    }

    public boolean getCompleteRowsOnly() {
        return this.m_CompleteRowsOnly;
    }

    public void setCompleteRowsOnly(boolean value) {
        this.m_CompleteRowsOnly = value;
        this.reset();
    }

    public String completeRowsOnlyTipText() {
        return "Whether only those IDs that have source data in all spreadsheets should be merged.";
    }

    protected String checkAllSpreadsheetsHaveIDColumn(SpreadSheet[] spreadsheets) {
        for (SpreadSheet spreadsheet : spreadsheets) {
            int idColumnIndex = this.findColumnIndexOfUniqueID(spreadsheet);
            if (idColumnIndex != -1) continue;
            return "Dataset " + spreadsheet.getName() + " does not have the ID column (" + this.m_UniqueID + ")";
        }
        return null;
    }

    protected boolean isUniqueIDName(String columnName) {
        return columnName.equals(this.m_UniqueID);
    }

    protected int findColumnIndexOfUniqueID(SpreadSheet spreadsheet) {
        return spreadsheet.getHeaderRow().indexOfContent(this.m_UniqueID);
    }

    @Override
    protected int compare(List<AbstractMerge.SourceColumn> sources1, List<AbstractMerge.SourceColumn> sources2) {
        boolean idName1 = this.isUniqueIDName(sources1.get((int)0).columnName);
        boolean idName2 = this.isUniqueIDName(sources2.get((int)0).columnName);
        if (idName1 && !idName2) {
            return -1;
        }
        if (!idName1 && idName2) {
            return 1;
        }
        return super.compare(sources1, sources2);
    }

    @Override
    protected String getMappedColumnName(AbstractMerge.SourceColumn source) {
        if (this.isUniqueIDName(source.columnName)) {
            return source.columnName;
        }
        return super.getMappedColumnName(source);
    }

    @Override
    protected Enumeration<int[]> getRowSetEnumeration() {
        return new UniqueIDEnumeration(this.m_Spreadsheets);
    }

    @Override
    protected String check(SpreadSheet[] datasets) {
        String result = super.check(datasets);
        if (result != null) {
            return result;
        }
        return this.checkAllSpreadsheetsHaveIDColumn(datasets);
    }

    @Override
    protected String checkColumnMapping(Map<String, List<AbstractMerge.SourceColumn>> columnMapping) {
        String result = super.checkColumnMapping(columnMapping);
        if (result != null) {
            return result;
        }
        if (this.isAnyClassColumn(columnMapping.get(this.m_UniqueID))) {
            result = "The provided unique ID (" + this.getUniqueID() + ") is also a class column.";
        }
        return result;
    }

    public class UniqueIDEnumeration
    implements Enumeration<int[]> {
        private Map<Object, int[]> m_UniqueIDRowMap;
        private Iterator<Object> m_InternalIterator;

        private UniqueIDEnumeration(SpreadSheet[] spreadsheets) {
            this.recordUniqueIDs(spreadsheets);
            this.m_InternalIterator = this.m_UniqueIDRowMap.keySet().iterator();
        }

        private void recordUniqueIDs(SpreadSheet[] spreadsheetsToMerge) {
            this.m_UniqueIDRowMap = new LinkedHashMap<Object, int[]>();
            for (int spreadsheetIndex = 0; spreadsheetIndex < spreadsheetsToMerge.length; ++spreadsheetIndex) {
                SpreadSheet spreadsheet = spreadsheetsToMerge[spreadsheetIndex];
                int uniqueIDColumnIndex = JoinOnID.this.findColumnIndexOfUniqueID(spreadsheet);
                if (uniqueIDColumnIndex == -1) continue;
                for (int rowIndex = 0; rowIndex < spreadsheet.getRowCount(); ++rowIndex) {
                    DataRow row = spreadsheet.getRow(rowIndex);
                    Object id = JoinOnID.this.getValue(row, uniqueIDColumnIndex);
                    if (id == null) continue;
                    if (!this.m_UniqueIDRowMap.containsKey(id)) {
                        this.m_UniqueIDRowMap.put(id, this.initialiseRowSet(spreadsheetsToMerge.length));
                    }
                    int[] rowInstanceTable = this.m_UniqueIDRowMap.get(id);
                    rowInstanceTable[spreadsheetIndex] = rowIndex;
                }
            }
            if (JoinOnID.this.getCompleteRowsOnly()) {
                this.removeIncompleteRows();
            }
        }

        private int[] initialiseRowSet(int size) {
            int[] rowSet = new int[size];
            for (int i = 0; i < size; ++i) {
                rowSet[i] = -1;
            }
            return rowSet;
        }

        private void removeIncompleteRows() {
            Iterator<Object> idIterator = this.m_UniqueIDRowMap.keySet().iterator();
            block0: while (idIterator.hasNext()) {
                int[] rowSet;
                Object id = idIterator.next();
                for (int rowEntry : rowSet = this.m_UniqueIDRowMap.get(id)) {
                    if (rowEntry != -1) continue;
                    idIterator.remove();
                    continue block0;
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_InternalIterator.hasNext();
        }

        @Override
        public int[] nextElement() {
            Object nextID = this.m_InternalIterator.next();
            return this.m_UniqueIDRowMap.get(nextID);
        }
    }
}

