/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheetpreview;

import adams.core.Utils;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.core.spreadsheetpreview.AbstractSpreadSheetPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;

public class SimpleText
extends AbstractSpreadSheetPreview {
    private static final long serialVersionUID = -3455538265861369251L;
    protected SpreadSheetColumnRange m_Columns;
    protected Font m_Font;
    protected String m_MissingValue;

    public String globalInfo() {
        return "Simply displays the specified columns as text.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("font", "font", (Object)this.getDefaultFont());
        this.m_OptionManager.add("missing-value", "missingValue", (Object)"?");
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The spreadsheet columns to display.";
    }

    protected Font getDefaultFont() {
        return Fonts.getMonospacedFont();
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font for the text area.";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The string to use for missing values.";
    }

    @Override
    public AbstractSpreadSheetPreview.AbstractSpreadSheetPreviewPanel generate() {
        SimpleTextPanel result = new SimpleTextPanel();
        result.setTextFont(this.m_Font);
        result.setColumns(this.m_Columns.getClone());
        result.setMissingValue(this.m_MissingValue);
        return result;
    }

    public static class SimpleTextPanel
    extends AbstractSpreadSheetPreview.AbstractSpreadSheetPreviewPanel {
        private static final long serialVersionUID = -3009467848041701061L;
        protected BaseTextArea m_TextArea;
        protected SpreadSheetColumnRange m_Columns;
        protected String m_MissingValue;

        protected void initialize() {
            super.initialize();
            this.m_Columns = new SpreadSheetColumnRange("first-last");
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_TextArea = new BaseTextArea();
            this.m_TextArea.setTextFont(Fonts.getMonospacedFont());
            this.add((Component)new BaseScrollPane((Component)this.m_TextArea), "Center");
        }

        public void setColumns(SpreadSheetColumnRange value) {
            this.m_Columns = value;
        }

        public SpreadSheetColumnRange getColumns() {
            return this.m_Columns;
        }

        public void setTextFont(Font value) {
            this.m_TextArea.setTextFont(value);
        }

        public Font getTextFont() {
            return this.m_TextArea.getTextFont();
        }

        public void setMissingValue(String value) {
            this.m_MissingValue = value;
        }

        public String getMissingValue() {
            return this.m_MissingValue;
        }

        @Override
        protected String doPreview(SpreadSheet sheet, int[] rows) {
            this.m_TextArea.setText("");
            this.m_Columns.setData(sheet);
            int[] cols = this.m_Columns.getIntIndices();
            StringBuilder text = new StringBuilder();
            for (int i = 0; i < rows.length; ++i) {
                DataRow row = sheet.getRow(rows[i]);
                if (i > 0) {
                    text.append("---\n\n");
                }
                for (int n = 0; n < cols.length; ++n) {
                    text.append(sheet.getColumnName(cols[n])).append(":\n");
                    String cell = row.hasCell(cols[n]) && !row.getCell(cols[n]).isMissing() ? row.getCell(cols[n]).getContent() : this.m_MissingValue;
                    text.append(Utils.indent((String)cell, (int)2)).append("\n");
                }
            }
            this.m_TextArea.setText(text.toString());
            this.m_TextArea.setCaretPosition(0);
            return null;
        }
    }
}

