/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.Properties;
import adams.core.Utils;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMean;
import adams.data.statistics.StatUtils;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.AbstractProcessSelectedRows;
import adams.gui.core.spreadsheettable.ProcessRow;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.dialog.PropertiesParameterDialog;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.io.Serializable;

public class ArrayStatistic
extends AbstractProcessSelectedRows
implements ProcessRow {
    private static final long serialVersionUID = 3101728458818516005L;
    public static final String KEY_COLUMNS = "columns";
    public static final String KEY_STATISTIC = "statistic";

    public String globalInfo() {
        return "Allows the user to calculate array statistics from selected rows.";
    }

    protected String getDefaultMenuItem() {
        return "Array statistics...";
    }

    public int minNumRows() {
        return 1;
    }

    public int maxNumRows() {
        return -1;
    }

    protected Properties promptParameters(SpreadSheetTable table) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)table) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)table), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)table), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        panel.addPropertyType(KEY_COLUMNS, PropertiesParameterPanel.PropertyType.RANGE);
        panel.setLabel(KEY_COLUMNS, "Columns");
        panel.setHelp(KEY_COLUMNS, "The columns to operate on");
        panel.addPropertyType(KEY_STATISTIC, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        panel.setLabel(KEY_STATISTIC, "Array statistic");
        panel.setHelp(KEY_STATISTIC, "The array statistics to apply");
        panel.setChooser(KEY_STATISTIC, (AbstractChooserPanel)new GenericObjectEditorPanel(AbstractArrayStatistic.class, (Object)new ArrayMean(), true));
        panel.setPropertyOrder(new String[]{KEY_COLUMNS, KEY_STATISTIC});
        Properties last = new Properties();
        last.setProperty(KEY_COLUMNS, "first-last");
        last.setObject(KEY_STATISTIC, (Object)new ArrayMean());
        dialog.setProperties(last);
        last = (Properties)table.getLastSetup(((Object)((Object)this)).getClass(), true, false);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    protected boolean doProcessSelectedRows(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        AbstractArrayStatistic.StatisticContainer stats;
        int[] rows = Utils.adjustIndices((int[])state.actRows, (int)2);
        Properties last = this.promptParameters(state.table);
        if (last == null) {
            return false;
        }
        AbstractArrayStatistic array = (AbstractArrayStatistic)last.getObject(KEY_STATISTIC, AbstractArrayStatistic.class);
        if (array == null) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)"Failed to instantiate array statistic!");
            return false;
        }
        if (array.getMin() != -1 && array.getMin() > state.actRows.length) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)("Statistic " + Utils.classToString((Object)last) + " requires at least " + array.getMin() + " rows!"));
        }
        if (array.getMax() != -1 && array.getMax() < state.actRows.length) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)("Statistic " + Utils.classToString((Object)last) + " can only handle at most " + array.getMax() + " rows!"));
        }
        state.table.addLastSetup(((Object)((Object)this)).getClass(), true, false, (Object)last);
        SpreadSheet sheet = state.table.toSpreadSheet(state.range, true);
        SpreadSheetColumnRange columns = new SpreadSheetColumnRange(last.getProperty(KEY_COLUMNS, "first-last"));
        columns.setData(sheet);
        int[] cols = columns.getIntIndices();
        for (int row = 0; row < sheet.getRowCount(); ++row) {
            array.add((Serializable[])StatUtils.toNumberArray((double[])SpreadSheetUtils.getNumericRow((SpreadSheet)sheet, (int)row, (int[])cols)));
        }
        try {
            stats = array.calculate();
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)("Failed to calculate statistics for rows #" + Utils.arrayToString((Object)rows) + "!"), (Throwable)e);
            return false;
        }
        SpreadSheetDialog dialogStats = GUIHelper.getParentDialog((Container)state.table) != null ? new SpreadSheetDialog(GUIHelper.getParentDialog((Container)state.table), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(GUIHelper.getParentFrame((Container)state.table), false);
        dialogStats.setDefaultCloseOperation(2);
        dialogStats.setTitle("Statistics for rows #" + Utils.arrayToString((Object)rows));
        dialogStats.setSpreadSheet(stats.toSpreadSheet());
        dialogStats.pack();
        dialogStats.setLocationRelativeTo(null);
        dialogStats.setVisible(true);
        return true;
    }

    public boolean processRow(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        return this.processSelectedRows(state);
    }
}

