/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.colstatistic.AbstractColumnStatistic;
import adams.data.spreadsheet.colstatistic.Mean;
import adams.gui.core.GUIHelper;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheettable.AbstractProcessColumn;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;

public class ColumnStatistic
extends AbstractProcessColumn {
    private static final long serialVersionUID = 3101728458818516005L;

    public String globalInfo() {
        return "Allows the user to calculate statistics for a column.";
    }

    public String getMenuItem() {
        return "Column statistics...";
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    public boolean doProcessColumn(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)state.table) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)state.table), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)state.table), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(AbstractColumnStatistic.class);
        setup.getGOEEditor().setCanChangeClassInDialog(true);
        AbstractColumnStatistic last = (AbstractColumnStatistic)((Object)state.table.getLastSetup(((Object)((Object)this)).getClass(), true, false));
        if (last == null) {
            last = new Mean();
        }
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)state.table));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return false;
        }
        last = (AbstractColumnStatistic)((Object)setup.getCurrent());
        state.table.addLastSetup(((Object)((Object)this)).getClass(), true, false, (Object)last);
        SpreadSheet sheet = state.table.toSpreadSheet(state.range, true);
        SpreadSheet stats = last.generate(sheet, state.actCol);
        if (stats == null) {
            if (last.hasLastError()) {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)("Failed to calculate statistics for column #" + (state.actCol + 1) + ": " + last.getLastError()));
            } else {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)("Failed to calculate statistics for column #" + (state.actCol + 1) + "!"));
            }
        } else {
            SpreadSheetDialog dialog = GUIHelper.getParentDialog((Container)state.table) != null ? new SpreadSheetDialog(GUIHelper.getParentDialog((Container)state.table), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(GUIHelper.getParentFrame((Container)state.table), false);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Statistics for column #" + (state.actCol + 1) + "/" + sheet.getColumnName(state.actCol));
            dialog.setSpreadSheet(stats);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        return stats != null;
    }
}

