/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractRowStatistic;
import adams.data.spreadsheet.rowstatistic.Mean;
import adams.gui.core.GUIHelper;
import adams.gui.core.spreadsheettable.AbstractProcessRow;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;

public class RowStatistic
extends AbstractProcessRow {
    private static final long serialVersionUID = 3101728458818516005L;

    public String globalInfo() {
        return "Allows the user to calculate statistics for a row.";
    }

    public String getMenuItem() {
        return "Row statistics...";
    }

    protected boolean doProcessRow(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)state.table) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)state.table), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)state.table), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(AbstractRowStatistic.class);
        setup.getGOEEditor().setCanChangeClassInDialog(true);
        AbstractRowStatistic last = (AbstractRowStatistic)((Object)state.table.getLastSetup(((Object)((Object)this)).getClass(), true, false));
        if (last == null) {
            last = new Mean();
        }
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)state.table));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return false;
        }
        last = (AbstractRowStatistic)((Object)setup.getCurrent());
        state.table.addLastSetup(((Object)((Object)this)).getClass(), true, false, (Object)last);
        SpreadSheet stats = last.generate(state.table.toSpreadSheet(), state.actRow);
        if (stats == null) {
            if (last.hasLastError()) {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)("Failed to calculate statistics for row #" + (state.actRow + 1) + ": " + last.getLastError()));
            } else {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)("Failed to calculate statistics for row #" + (state.actRow + 2) + "!"));
            }
        } else {
            SpreadSheetDialog dialog = GUIHelper.getParentDialog((Container)state.table) != null ? new SpreadSheetDialog(GUIHelper.getParentDialog((Container)state.table), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(GUIHelper.getParentFrame((Container)state.table), false);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Statistics for row #" + (state.actRow + 2));
            dialog.setSpreadSheet(stats);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        return stats != null;
    }
}

