/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor;

import adams.core.MessageCollection;
import adams.core.logging.CustomLoggingLevelObject;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.tools.SpreadSheetProcessorPanel;
import java.awt.Component;

public abstract class AbstractWidget
extends CustomLoggingLevelObject
implements Comparable<AbstractWidget> {
    private static final long serialVersionUID = 5621070732995969891L;
    protected SpreadSheetProcessorPanel m_Owner;

    public void setOwner(SpreadSheetProcessorPanel value) {
        this.m_Owner = value;
    }

    public SpreadSheetProcessorPanel getOwner() {
        return this.m_Owner;
    }

    public abstract String getName();

    public abstract Component getWidget();

    public abstract void update();

    public String toString() {
        return this.getName();
    }

    public abstract void assign(AbstractWidget var1);

    public abstract Object serialize();

    public abstract void deserialize(Object var1, MessageCollection var2);

    protected void notifyOwner(SpreadSheetProcessorEvent.EventType type, String message) {
        if (this.m_Owner == null) {
            return;
        }
        this.m_Owner.processorStateChanged(new SpreadSheetProcessorEvent(this.m_Owner, type, message));
    }

    @Override
    public int compareTo(AbstractWidget o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractWidget && this.compareTo((AbstractWidget)obj) == 0;
    }
}

