/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.processors;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.io.input.FlowReader;
import adams.data.io.output.FlowWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.SubProcess;
import adams.flow.core.Actor;
import adams.flow.core.Compatibility;
import adams.flow.core.Token;
import adams.gui.chooser.FlowFileChooser;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.flow.FlowPanel;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.processors.AbstractProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;

public class FlowProcessor
extends AbstractProcessor {
    private static final long serialVersionUID = 2926743330826433963L;
    public static final String KEY_FLOW = "flow";
    protected BasePanel m_PanelWidget;
    protected FlowPanel m_PanelFlow;
    protected BaseButton m_ButtonNew;
    protected BaseButton m_ButtonLoad;
    protected BaseButton m_ButtonSave;
    protected BaseButton m_ButtonCheck;
    protected BaseButton m_ButtonRun;
    protected FlowFileChooser m_FileChooserFlow;

    @Override
    public String getName() {
        return "Flow";
    }

    @Override
    public Component getWidget() {
        if (this.m_PanelWidget == null) {
            this.m_FileChooserFlow = new FlowFileChooser();
            this.m_PanelWidget = new BasePanel((LayoutManager)new BorderLayout());
            this.m_PanelFlow = new FlowPanel();
            this.m_PanelFlow.getTitleGenerator().setEnabled(false);
            this.m_PanelFlow.setMinimumSize(new Dimension(400, 0));
            this.m_PanelFlow.getUndo().clear();
            this.m_PanelWidget.add((Component)this.m_PanelFlow, (Object)"Center");
            JPanel panelBottom = new JPanel(new BorderLayout());
            this.m_PanelWidget.add((Component)panelBottom, (Object)"South");
            JPanel panelButtons = new JPanel(new FlowLayout(2));
            panelBottom.add((Component)panelButtons, "East");
            this.m_ButtonNew = new BaseButton((Icon)GUIHelper.getIcon((String)"new.gif"));
            this.m_ButtonNew.addActionListener(e -> this.newFlow());
            panelButtons.add((Component)this.m_ButtonNew);
            this.m_ButtonLoad = new BaseButton((Icon)GUIHelper.getIcon((String)"open.gif"));
            this.m_ButtonLoad.addActionListener(e -> this.loadFlow());
            panelButtons.add((Component)this.m_ButtonLoad);
            this.m_ButtonSave = new BaseButton((Icon)GUIHelper.getIcon((String)"save.gif"));
            this.m_ButtonSave.addActionListener(e -> this.saveFlow());
            panelButtons.add((Component)this.m_ButtonSave);
            this.m_ButtonCheck = new BaseButton((Icon)GUIHelper.getIcon((String)"validate.png"));
            this.m_ButtonCheck.addActionListener(e -> this.checkFlow(false));
            panelButtons.add((Component)this.m_ButtonCheck);
            this.m_ButtonRun = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
            this.m_ButtonRun.addActionListener(e -> this.runFlow());
            panelButtons.add((Component)this.m_ButtonRun);
            this.newFlow();
        }
        return this.m_PanelWidget;
    }

    protected void newFlow() {
        this.m_PanelFlow.setCurrentFlow((Actor)new SubProcess());
    }

    protected void loadFlow() {
        int retVal = this.m_FileChooserFlow.showOpenDialog((Component)((Object)this.m_Owner));
        if (retVal != 0) {
            return;
        }
        FlowReader reader = (FlowReader)this.m_FileChooserFlow.getReader();
        Actor actor = reader.readActor(this.m_FileChooserFlow.getSelectedFile());
        if (actor instanceof SubProcess) {
            this.m_PanelFlow.setCurrentFlow(actor);
        } else {
            GUIHelper.showErrorMessage((Component)((Object)this.m_Owner), (String)("The outermost actor in the flow must a " + SubProcess.class.getName() + ", encountered: " + actor.getClass().getName()));
        }
    }

    protected void saveFlow() {
        int retVal = this.m_FileChooserFlow.showSaveDialog((Component)((Object)this.m_Owner));
        if (retVal != 0) {
            return;
        }
        FlowWriter writer = (FlowWriter)this.m_FileChooserFlow.getWriter();
        if (!writer.write(this.m_PanelFlow.getCurrentFlow(), this.m_FileChooserFlow.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this.m_Owner), (String)("Failed to write flow snippet to: " + this.m_FileChooserFlow.getSelectedFile()));
        }
    }

    protected boolean checkFlow(boolean silent) {
        String msg = null;
        Actor actor = this.m_PanelFlow.getCurrentFlow();
        SubProcess sub = null;
        if (!(actor instanceof SubProcess)) {
            msg = "Outermost actor must be a " + SubProcess.class.getName() + ", found: " + actor.getClass().getName();
        } else {
            sub = (SubProcess)actor;
        }
        if (msg == null) {
            Compatibility comp = new Compatibility();
            if (!comp.isCompatible(new Class[]{SpreadSheet.class}, sub.accepts())) {
                msg = "Flow snippet does not accept " + SpreadSheet.class.getClass() + ", found: " + Utils.classesToString((Class[])sub.accepts());
            } else if (!comp.isCompatible(sub.generates(), new Class[]{SpreadSheet.class})) {
                msg = "Flow snippet does not generate " + SpreadSheet.class.getClass() + ", found: " + Utils.classesToString((Class[])sub.generates());
            }
        }
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this.m_Owner), (String)("Flow failed test:\n" + msg));
        } else if (!silent) {
            GUIHelper.showInformationMessage((Component)((Object)this.m_Owner), (String)"Flow passed test!");
        }
        return msg == null;
    }

    protected void runFlow() {
        this.notifyOwner(SpreadSheetProcessorEvent.EventType.PROCESS_DATA, "Execute flow");
    }

    public void setCurrentFlow(Actor value) {
        this.m_PanelFlow.setCurrentFlow(value);
    }

    public Actor getCurrentFlow() {
        return this.m_PanelFlow.getCurrentFlow();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof FlowProcessor) {
            FlowProcessor widget = (FlowProcessor)other;
            widget.getWidget();
            this.setCurrentFlow(widget.getCurrentFlow());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_FLOW, this.getCurrentFlow().toCommandLine());
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_FLOW)) {
                try {
                    this.setCurrentFlow((Actor)OptionUtils.forAnyCommandLine(Actor.class, (String)((String)map.get(KEY_FLOW))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate flow from: " + map.get(KEY_FLOW));
                }
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    public void update() {
        this.m_ButtonRun.setEnabled(this.m_Owner.getSourceData() != null);
    }

    @Override
    protected SpreadSheet doProcess(SpreadSheet data, MessageCollection errors) {
        SpreadSheet result = null;
        SubProcess subflow = (SubProcess)this.m_PanelFlow.getCurrentFlow();
        String msg = subflow.setUp();
        if (msg != null) {
            errors.add(msg);
        }
        if (errors.isEmpty()) {
            subflow.input(new Token((Object)data));
            msg = subflow.execute();
            if (msg != null) {
                errors.add(msg);
            }
            this.m_Owner.addGeneratedFlow((Actor)subflow);
        }
        if (errors.isEmpty()) {
            if (subflow.hasPendingOutput()) {
                result = (SpreadSheet)subflow.output().getPayload();
                this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_PROCESSED, "Executed flow");
            } else {
                errors.add("Flow did not generate any data!");
            }
            subflow.wrapUp();
        }
        return result;
    }
}

