/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.sources;

import adams.core.MessageCollection;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.sources.AbstractSource;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class ClipboardSource
extends AbstractSource {
    private static final long serialVersionUID = -4475860171792209905L;
    public static final String KEY_READER = "reader";
    protected BasePanel m_Widget;
    protected GenericObjectEditorPanel m_PanelReader;
    protected BaseButton m_ButtonPaste;
    protected SpreadSheet m_Data;

    @Override
    public String getName() {
        return "Clipboard";
    }

    @Override
    public Component getWidget() {
        if (this.m_Widget == null) {
            this.m_Widget = new BasePanel((LayoutManager)new BorderLayout());
            ParameterPanel panelParams = new ParameterPanel();
            this.m_Widget.add((Component)panelParams, (Object)"Center");
            CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
            reader.setSeparator("\\t");
            this.m_PanelReader = new GenericObjectEditorPanel(SpreadSheetReader.class, (Object)reader, false);
            panelParams.addParameter("Reader", (Component)this.m_PanelReader);
            this.m_ButtonPaste = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
            this.m_ButtonPaste.addActionListener(e -> this.paste());
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.add((Component)this.m_ButtonPaste);
            panelParams.addParameter("Paste", (Component)panel);
        }
        return this.m_Widget;
    }

    protected void paste() {
        SwingWorker worker = new SwingWorker(){
            String error;

            protected Object doInBackground() throws Exception {
                ClipboardSource.this.m_ButtonPaste.setEnabled(false);
                StringReader sreader = new StringReader(ClipboardHelper.pasteStringFromClipboard());
                CsvSpreadSheetReader reader = (CsvSpreadSheetReader)ClipboardSource.this.m_PanelReader.getCurrent();
                try {
                    ClipboardSource.this.m_Data = reader.read((Reader)sreader);
                    if (ClipboardSource.this.m_Data == null) {
                        this.error = reader.getLastError();
                    } else {
                        ClipboardSource.this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_AVAILABLE, "Data pasted from clipboard!");
                    }
                }
                catch (Exception e) {
                    this.error = LoggingHelper.handleException((LoggingSupporter)ClipboardSource.this, (String)"Failed to paste data from clipboard!", (Throwable)e);
                    ClipboardSource.this.m_Data = null;
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                ClipboardSource.this.m_ButtonPaste.setEnabled(true);
                if (this.error != null) {
                    GUIHelper.showErrorMessage((Component)ClipboardSource.this.m_Widget.getParent(), (String)this.error);
                }
            }
        };
        worker.execute();
    }

    public void setCurrentReader(SpreadSheetReader value) {
        this.m_PanelReader.setCurrent((Object)value);
    }

    public SpreadSheetReader getCurrentReader() {
        return (SpreadSheetReader)this.m_PanelReader.getCurrent();
    }

    @Override
    public boolean hasData() {
        return this.m_Data != null;
    }

    @Override
    public SpreadSheet getData() {
        return this.m_Data;
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof ClipboardSource) {
            ClipboardSource widget = (ClipboardSource)other;
            widget.getWidget();
            this.setCurrentReader(widget.getCurrentReader());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_READER, OptionUtils.getCommandLine((Object)this.getCurrentReader()));
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_READER)) {
                try {
                    this.setCurrentReader((SpreadSheetReader)OptionUtils.forAnyCommandLine(SpreadSheetReader.class, (String)((String)map.get(KEY_READER))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate reader from: " + map.get(KEY_READER));
                }
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    public void update() {
        this.m_ButtonPaste.setEnabled(ClipboardHelper.canPasteStringFromClipboard());
    }
}

