/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.targets;

import adams.core.MessageCollection;
import adams.core.base.BaseInteger;
import adams.core.base.BaseObject;
import adams.core.base.BasePassword;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.ColumnNameConversion;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.data.spreadsheet.sql.Writer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.SQLF;
import adams.db.SQLIntf;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseObjectTextField;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.core.SqlConnectionPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.targets.AbstractTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class DatabaseTarget
extends AbstractTarget {
    private static final long serialVersionUID = 6535516712611654393L;
    public static final String KEY_URL = "url";
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_TYPEMAPPER = "typemapper";
    public static final String KEY_TABLE = "table";
    public static final String KEY_COLUMNNAMECONVERSION = "columnnameconversion";
    public static final String KEY_MAXSTRINGLENGTH = "maxstringlength";
    public static final String KEY_STRINGCOLUMNSQL = "stringcolumnsql";
    public static final String KEY_BATCHSIZE = "batchsize";
    protected BasePanel m_Widget;
    protected SqlConnectionPanel m_PanelConnection;
    protected GenericObjectEditorPanel m_PanelTypeMapper;
    protected BaseTextField m_TextTable;
    protected BaseComboBox<ColumnNameConversion> m_ComboBoxColumnNameConversion;
    protected BaseObjectTextField<BaseInteger> m_TextMaxStringLength;
    protected BaseTextField m_TextStringColumnSQL;
    protected BaseObjectTextField<BaseInteger> m_TextBatchSize;
    protected BaseButton m_ButtonExecute;

    @Override
    public String getName() {
        return "Database";
    }

    @Override
    public Component getWidget() {
        if (this.m_Widget == null) {
            this.m_Widget = new BasePanel((LayoutManager)new BorderLayout());
            JPanel topPanel = new JPanel(new BorderLayout());
            this.m_Widget.add((Component)topPanel, (Object)"North");
            this.m_PanelConnection = new SqlConnectionPanel();
            this.m_PanelConnection.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            topPanel.add((Component)this.m_PanelConnection, "North");
            ParameterPanel paramsPanel = new ParameterPanel();
            topPanel.add((Component)paramsPanel, "Center");
            this.m_PanelTypeMapper = new GenericObjectEditorPanel(AbstractTypeMapper.class, (Object)new DefaultTypeMapper(), true);
            paramsPanel.addParameter("Type mapper", (Component)this.m_PanelTypeMapper);
            this.m_TextTable = new BaseTextField();
            paramsPanel.addParameter("Table", (Component)this.m_TextTable);
            this.m_ComboBoxColumnNameConversion = new BaseComboBox((Object[])ColumnNameConversion.values());
            paramsPanel.addParameter("Column name conversion", this.m_ComboBoxColumnNameConversion);
            this.m_TextMaxStringLength = new BaseObjectTextField((BaseObject)new BaseInteger(Integer.valueOf(50)));
            paramsPanel.addParameter("Max string length", this.m_TextMaxStringLength);
            this.m_TextStringColumnSQL = new BaseTextField("VARCHAR(@MAX)");
            paramsPanel.addParameter("String column SQL", (Component)this.m_TextStringColumnSQL);
            this.m_TextBatchSize = new BaseObjectTextField((BaseObject)new BaseInteger(Integer.valueOf(1)));
            paramsPanel.addParameter("Batch size", this.m_TextBatchSize);
            this.m_ButtonExecute = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
            this.m_ButtonExecute.addActionListener(e -> this.generate());
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.add((Component)this.m_ButtonExecute);
            paramsPanel.addParameter("Execute", (Component)panel);
        }
        return this.m_Widget;
    }

    @Override
    public void update() {
        this.m_ButtonExecute.setEnabled(this.m_Owner.getProcessorData() != null && !this.getCurrentTable().isEmpty());
    }

    protected void generate() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                DatabaseTarget.this.m_ButtonExecute.setEnabled(false);
                DatabaseTarget.this.m_Owner.processorStateChanged(new SpreadSheetProcessorEvent(DatabaseTarget.this.m_Owner, SpreadSheetProcessorEvent.EventType.OUTPUT_DATA, "Store data: " + DatabaseTarget.this.getCurrentConnection().toCommandLine() + "/" + DatabaseTarget.this.getCurrentTable()));
                return null;
            }

            @Override
            protected void done() {
                super.done();
                DatabaseTarget.this.m_ButtonExecute.setEnabled(true);
            }
        };
        worker.execute();
    }

    public void setCurrentConnection(AbstractDatabaseConnection value) {
        this.m_PanelConnection.setDatabaseConnection(value);
    }

    public AbstractDatabaseConnection getCurrentConnection() {
        return this.m_PanelConnection.getDatabaseConnection();
    }

    public void setCurrentTypeMapper(AbstractTypeMapper value) {
        this.m_PanelTypeMapper.setCurrent((Object)value);
    }

    public AbstractTypeMapper getCurrentTypeMapper() {
        return (AbstractTypeMapper)((Object)this.m_PanelTypeMapper.getCurrent());
    }

    public void setCurrentTable(String value) {
        this.m_TextTable.setText(value);
    }

    public String getCurrentTable() {
        return this.m_TextTable.getText();
    }

    public void setCurrentColumnNameConversion(ColumnNameConversion value) {
        this.m_ComboBoxColumnNameConversion.setSelectedItem((Object)value);
    }

    public ColumnNameConversion getCurrentColumnNameConversion() {
        return (ColumnNameConversion)((Object)this.m_ComboBoxColumnNameConversion.getSelectedItem());
    }

    public void setCurrentMaxStringLength(BaseInteger value) {
        this.m_TextMaxStringLength.setObject((BaseObject)value);
    }

    public BaseInteger getCurrentMaxStringLength() {
        return (BaseInteger)this.m_TextMaxStringLength.getObject();
    }

    public void setCurrentStringColumnSQL(String value) {
        this.m_TextStringColumnSQL.setText(value);
    }

    public String getCurrentStringColumnSQL() {
        return this.m_TextStringColumnSQL.getText();
    }

    public void setCurrentBatchSize(BaseInteger value) {
        this.m_TextBatchSize.setObject((BaseObject)value);
    }

    public BaseInteger getCurrentBatchSize() {
        return (BaseInteger)this.m_TextBatchSize.getObject();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof DatabaseTarget) {
            DatabaseTarget widget = (DatabaseTarget)other;
            widget.getWidget();
            this.setCurrentConnection(widget.getCurrentConnection());
            this.setCurrentTypeMapper(widget.getCurrentTypeMapper());
            this.setCurrentTable(widget.getCurrentTable());
            this.setCurrentColumnNameConversion(widget.getCurrentColumnNameConversion());
            this.setCurrentMaxStringLength(widget.getCurrentMaxStringLength());
            this.setCurrentStringColumnSQL(widget.getCurrentStringColumnSQL());
            this.setCurrentBatchSize(widget.getCurrentBatchSize());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_URL, this.getCurrentConnection().getURL());
        result.put(KEY_USER, this.getCurrentConnection().getUser());
        result.put(KEY_PASSWORD, this.getCurrentConnection().getPassword().stringValue());
        result.put(KEY_TYPEMAPPER, OptionUtils.getCommandLine((Object)this.m_PanelTypeMapper.getCurrent()));
        result.put(KEY_TABLE, this.getCurrentTable());
        result.put(KEY_COLUMNNAMECONVERSION, this.getCurrentColumnNameConversion().toString());
        result.put(KEY_MAXSTRINGLENGTH, (String)this.getCurrentMaxStringLength());
        result.put(KEY_STRINGCOLUMNSQL, this.getCurrentStringColumnSQL());
        result.put(KEY_BATCHSIZE, (String)this.getCurrentBatchSize());
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_URL) && map.containsKey(KEY_USER) && map.containsKey(KEY_PASSWORD)) {
                DatabaseConnection conn = new DatabaseConnection((String)map.get(KEY_URL), (String)map.get(KEY_USER), new BasePassword((String)map.get(KEY_PASSWORD)));
                this.setCurrentConnection((AbstractDatabaseConnection)conn);
            }
            if (map.containsKey(KEY_TYPEMAPPER)) {
                try {
                    this.setCurrentTypeMapper((AbstractTypeMapper)((Object)OptionUtils.forAnyCommandLine(AbstractTypeMapper.class, (String)((String)map.get(KEY_TYPEMAPPER)))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate type mapper from: " + map.get(KEY_TYPEMAPPER));
                }
            }
            if (map.containsKey(KEY_TABLE)) {
                this.setCurrentTable((String)map.get(KEY_TABLE));
            }
            if (map.containsKey(KEY_COLUMNNAMECONVERSION)) {
                this.setCurrentColumnNameConversion(ColumnNameConversion.valueOf((String)map.get(KEY_COLUMNNAMECONVERSION)));
            }
            if (map.containsKey(KEY_MAXSTRINGLENGTH)) {
                this.setCurrentMaxStringLength(new BaseInteger((String)map.get(KEY_MAXSTRINGLENGTH)));
            }
            if (map.containsKey(KEY_STRINGCOLUMNSQL)) {
                this.setCurrentStringColumnSQL((String)map.get(KEY_STRINGCOLUMNSQL));
            }
            if (map.containsKey(KEY_BATCHSIZE)) {
                this.setCurrentBatchSize(new BaseInteger((String)map.get(KEY_BATCHSIZE)));
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    protected void doProcess(final SpreadSheet data, MessageCollection errors) {
        final AbstractDatabaseConnection conn = this.getCurrentConnection();
        final AbstractTypeMapper typeMapper = (AbstractTypeMapper)((Object)this.m_PanelTypeMapper.getCurrent());
        final String table = this.m_TextTable.getText();
        final ColumnNameConversion conversion = (ColumnNameConversion)((Object)this.m_ComboBoxColumnNameConversion.getSelectedItem());
        final String strColSQL = this.m_TextStringColumnSQL.getText();
        final int maxStrLen = ((BaseInteger)this.m_TextMaxStringLength.getObject()).intValue();
        final int batchSize = ((BaseInteger)this.m_TextBatchSize.getObject()).intValue();
        SwingWorker worker = new SwingWorker(){
            String error = null;

            protected Object doInBackground() throws Exception {
                Writer writer;
                DatabaseTarget.this.m_ButtonExecute.setEnabled(false);
                SQLF sql = SQLF.getSingleton((AbstractDatabaseConnection)DatabaseTarget.this.m_PanelConnection.getDatabaseConnection());
                try {
                    writer = new Writer(data, typeMapper, table, sql.getMaxColumnNameLength(), conversion, strColSQL, maxStrLen, batchSize);
                    writer.setLoggingLevel(DatabaseTarget.this.getLoggingLevel());
                }
                catch (Exception e) {
                    writer = null;
                    this.error = LoggingHelper.handleException((LoggingSupporter)DatabaseTarget.this, (String)("Failed to store data!" + conn.toCommandLine() + "/" + table), (Throwable)e);
                }
                if (writer != null) {
                    if (!sql.tableExists(table)) {
                        this.error = writer.createTable((SQLIntf)sql);
                    }
                    if (this.error == null) {
                        this.error = writer.writeData((SQLIntf)sql);
                    }
                }
                return this.error;
            }

            @Override
            protected void done() {
                super.done();
                if (this.error != null) {
                    GUIHelper.showErrorMessage((Component)((Object)DatabaseTarget.this.m_Owner), (String)this.error);
                } else {
                    DatabaseTarget.this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_OUTPUT, "Stored data: " + conn.toCommandLine() + "/" + table);
                }
            }
        };
        worker.execute();
    }
}

