/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectexport;

import adams.core.classmanager.ClassManager;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import nz.ac.waikato.cms.locator.ClassLocator;

public class SpreadSheetExporter
extends AbstractObjectExporter {
    private static final long serialVersionUID = 4899389310274830738L;
    protected SpreadSheetWriter m_Writer;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new CsvSpreadSheetWriter());
    }

    public void setWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The spreadsheet writer to use.";
    }

    public String getFormatDescription() {
        return "Spreadsheet files";
    }

    public String[] getFormatExtensions() {
        String[] classnames;
        ArrayList<String> result = new ArrayList<String>();
        for (String classname : classnames = AbstractSpreadSheetWriter.getWriters()) {
            try {
                String[] extensions;
                SpreadSheetWriter writer = (SpreadSheetWriter)ClassManager.getSingleton().forName(classname).newInstance();
                for (String extension : extensions = writer.getFormatExtensions()) {
                    if (result.contains(extension)) continue;
                    result.add(extension);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to instantiate '" + classname + "'!", (Throwable)e);
            }
        }
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(SpreadSheet.class, (Class)cls) || ClassLocator.hasInterface(SpreadSheetSupporter.class, (Class)cls);
    }

    protected String doExport(Object obj, File file) {
        SpreadSheet sheet = obj instanceof SpreadSheet ? (SpreadSheet)obj : ((SpreadSheetSupporter)obj).toSpreadSheet();
        if (!this.m_Writer.write(sheet, file)) {
            return "Failed to export spreadsheet to '" + file + "'!";
        }
        return null;
    }
}

