/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectrenderer;

import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.dialog.SpreadSheetPanel;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import java.awt.Component;
import java.util.Map;
import javax.swing.JPanel;
import nz.ac.waikato.cms.locator.ClassLocator;

public class MapRenderer
extends AbstractObjectRenderer {
    private static final long serialVersionUID = -3528006886476495175L;
    protected SpreadSheetPanel m_LastSheetPanel;

    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(Map.class, (Class)cls);
    }

    public boolean canRenderCached(Object obj, JPanel panel) {
        return this.m_LastSheetPanel != null;
    }

    protected SpreadSheet mapToSheet(Map map) {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("K").setContentAsString("Key");
        row.addCell("V").setContentAsString("Value");
        for (Object key : map.keySet()) {
            row = result.addRow();
            row.addCell("K").setNative(key);
            row.addCell("V").setNative(map.get(key));
        }
        return result;
    }

    protected String doRenderCached(Object obj, JPanel panel) {
        this.m_LastSheetPanel.setSpreadSheet(this.mapToSheet((Map)obj));
        panel.add((Component)this.m_LastSheetPanel, "Center");
        return null;
    }

    protected String doRender(Object obj, JPanel panel) {
        SpreadSheet sheet = this.mapToSheet((Map)obj);
        SpreadSheetPanel sheetPanel = new SpreadSheetPanel();
        sheetPanel.setSpreadSheet(sheet);
        sheetPanel.setShowSearch(true);
        panel.add((Component)sheetPanel, "Center");
        this.m_LastSheetPanel = sheetPanel;
        return null;
    }
}

