/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.jfreechart.chart;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;

public abstract class AbstractChartGenerator<T extends Dataset>
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 125224185085489847L;
    protected String m_Title;
    protected boolean m_Legend;
    protected boolean m_ToolTips;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("title", "title", (Object)"Plot");
        this.m_OptionManager.add("legend", "legend", (Object)false);
        this.m_OptionManager.add("tool-tips", "toolTips", (Object)false);
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title for the plot.";
    }

    public void setLegend(boolean value) {
        this.m_Legend = value;
        this.reset();
    }

    public boolean getLegend() {
        return this.m_Legend;
    }

    public String legendTipText() {
        return "If enabled, the legend of the plot is displayed.";
    }

    public void setToolTips(boolean value) {
        this.m_ToolTips = value;
        this.reset();
    }

    public boolean getToolTips() {
        return this.m_ToolTips;
    }

    public String toolTipsTipText() {
        return "If enabled, the tool tips of the plot get displayed.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"title", (Object)(this.m_Title.isEmpty() ? "-none-" : this.m_Title), (String)"title: ");
    }

    protected String check(T data) {
        if (data == null) {
            return "No data provided!";
        }
        return null;
    }

    protected abstract JFreeChart doGenerate(T var1);

    public JFreeChart generate(T data) {
        String msg = this.check(data);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doGenerate(data);
    }
}

