/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.jfreechart.chart;

import adams.gui.visualization.jfreechart.chart.AbstractChartGeneratorWithAxisLabels;
import adams.gui.visualization.jfreechart.chart.Orientation;
import adams.gui.visualization.jfreechart.dataset.ChartUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.SeriesDataset;
import org.jfree.data.xy.XYDataset;

public class ScatterPlot
extends AbstractChartGeneratorWithAxisLabels<XYDataset> {
    private static final long serialVersionUID = -4759011723765395176L;
    protected Orientation m_Orientation;

    public String globalInfo() {
        return "Creates a simple scatter plot from X-Y data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("orientation", "orientation", (Object)Orientation.VERTICAL);
    }

    public void setOrientation(Orientation value) {
        this.m_Orientation = value;
        this.reset();
    }

    public Orientation getOrientation() {
        return this.m_Orientation;
    }

    public String orientationTipText() {
        return "The orientation of the plot.";
    }

    @Override
    protected JFreeChart doGenerate(XYDataset data) {
        JFreeChart result = ChartFactory.createScatterPlot((String)this.m_Title, (String)this.m_LabelX, (String)this.m_LabelY, (XYDataset)data, (PlotOrientation)this.m_Orientation.getOrientation(), (boolean)this.m_Legend, (boolean)this.m_ToolTips, (boolean)false);
        int diagonal = ChartUtils.getDiagonalIndex((SeriesDataset)data);
        if (diagonal != -1) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            for (int i = 0; i < data.getSeriesCount(); ++i) {
                if (i == diagonal) {
                    renderer.setSeriesLinesVisible(i, true);
                    renderer.setSeriesShapesVisible(i, false);
                    continue;
                }
                renderer.setSeriesLinesVisible(i, false);
                renderer.setSeriesShapesVisible(i, true);
            }
            result.getXYPlot().setRenderer((XYItemRenderer)renderer);
        }
        return result;
    }
}

