/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.jfreechart.shape;

import adams.gui.visualization.jfreechart.shape.AbstractShapeGenerator;
import java.awt.Shape;
import org.jfree.util.ShapeUtilities;

public class Cross
extends AbstractShapeGenerator {
    private static final long serialVersionUID = 514268201924765348L;
    protected Type m_Type;
    protected float m_Length;
    protected float m_Thickness;

    public String globalInfo() {
        return "Creates a cross.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Type.DIAGONAL);
        this.m_OptionManager.add("length", "length", (Object)Float.valueOf(3.0f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("thickness", "thickness", (Object)Float.valueOf(0.25f), (Number)Float.valueOf(0.0f), null);
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the cross.";
    }

    public void setLength(float value) {
        this.m_Length = value;
        this.reset();
    }

    public float getLength() {
        return this.m_Length;
    }

    public String lengthTipText() {
        return "The length of the arms of the cross.";
    }

    public void setThickness(float value) {
        this.m_Thickness = value;
        this.reset();
    }

    public float getThickness() {
        return this.m_Thickness;
    }

    public String thicknessTipText() {
        return "The thickness of the arms of the cross.";
    }

    @Override
    protected Shape doGenerate() {
        switch (this.m_Type) {
            case DIAGONAL: {
                return ShapeUtilities.createDiagonalCross((float)this.m_Length, (float)this.m_Thickness);
            }
            case REGULAR: {
                return ShapeUtilities.createRegularCross((float)this.m_Length, (float)this.m_Thickness);
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
    }

    public static enum Type {
        REGULAR,
        DIAGONAL;

    }
}

