/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet;

import adams.core.Range;
import adams.data.Notes;
import adams.data.NotesHandler;
import adams.data.container.AbstractDataContainer;
import adams.data.container.DataContainer;
import adams.data.container.DataPointComparator;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPoint;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPointComparator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class SpreadSheetRow
extends AbstractDataContainer<SpreadSheetRowPoint>
implements MutableReportHandler<Report>,
NotesHandler,
SpreadSheetSupporter {
    private static final long serialVersionUID = 8553741559715144356L;
    public static final String REPORT_SPREADSHEET = "SpreadSheet-Name";
    public static final String REPORT_DB_ID = "DB-ID";
    public static final String REPORT_ID = "ID";
    public static final String REPORT_DISPLAY_ID = "Display-ID";
    public static final String REPORT_ROW = "SpreadSheet-Row";
    public static final String REPORT_ADDITIONAL_PREFIX = "Column-";
    protected static DataPointComparator m_Comparator;
    protected SpreadSheet m_DatasetHeader;
    protected Report m_Report = this.newReport();
    protected Notes m_Notes = new Notes();

    public SpreadSheetRow() {
        if (m_Comparator == null) {
            m_Comparator = this.newComparator();
        }
        this.setID("");
    }

    public void setID(String value) {
        super.setID(value);
        this.m_Report.addParameter(REPORT_DISPLAY_ID, value);
    }

    public DataPointComparator<SpreadSheetRowPoint> newComparator() {
        return new SpreadSheetRowPointComparator();
    }

    public DataPointComparator<SpreadSheetRowPoint> getComparator() {
        return m_Comparator;
    }

    public SpreadSheetRowPoint newPoint() {
        return new SpreadSheetRowPoint();
    }

    protected Report newReport() {
        Report result = new Report();
        result.addField((AbstractField)new Field(REPORT_SPREADSHEET, DataType.STRING));
        result.addField((AbstractField)new Field(REPORT_DB_ID, DataType.NUMERIC));
        result.addField((AbstractField)new Field(REPORT_ID, DataType.STRING));
        result.addField((AbstractField)new Field(REPORT_DISPLAY_ID, DataType.STRING));
        return result;
    }

    public void clear() {
        this.m_DatasetHeader = null;
        this.m_Report = this.newReport();
        super.clear();
    }

    public void assign(DataContainer<SpreadSheetRowPoint> other) {
        super.assign(other);
        this.m_DatasetHeader = ((SpreadSheetRow)other).getDatasetHeader();
        this.m_Report = ((SpreadSheetRow)other).getReport().getClone();
        this.m_Notes = ((SpreadSheetRow)other).getNotes().getClone();
    }

    public boolean hasDatasetHeader() {
        return this.m_DatasetHeader != null;
    }

    public SpreadSheet getDatasetHeader() {
        return this.m_DatasetHeader;
    }

    public void set(Row row) {
        this.set(row, -1, new int[0], new Range("first-last"), null);
    }

    public void set(Row row, int index, int[] additional, Range range, HashSet<Integer> attTypes) {
        Cell cell;
        int i;
        this.clear();
        this.m_DatasetHeader = row.getOwner().getHeader();
        range.setMax(row.getOwner().getColumnCount());
        ArrayList<SpreadSheetRowPoint> list = new ArrayList<SpreadSheetRowPoint>();
        for (i = 0; i < row.getOwner().getColumnCount(); ++i) {
            if (!range.isInRange(i) || attTypes != null && !attTypes.containsAll(row.getOwner().getContentTypes(i)) || (cell = row.getCell(i)) == null || cell.isMissing() || !cell.isNumeric()) continue;
            list.add(new SpreadSheetRowPoint(i, cell.toDouble()));
        }
        this.addAll(list);
        if (index != -1) {
            this.m_Report.addField((AbstractField)new Field(REPORT_ROW, DataType.NUMERIC));
            this.m_Report.addParameter(REPORT_ROW, (Object)new Double(index + 1));
        }
        for (i = 0; i < additional.length; ++i) {
            cell = row.getCell(additional[i]);
            if (cell == null || cell.isMissing()) continue;
            String fieldStr = REPORT_ADDITIONAL_PREFIX + (additional[i] + 1) + "-" + row.getOwner().getHeaderRow().getCell(i).getContent();
            if (cell.isNumeric()) {
                this.m_Report.addField((AbstractField)new Field(fieldStr, DataType.NUMERIC));
                this.m_Report.addParameter(fieldStr, (Object)cell.toDouble());
                continue;
            }
            this.m_Report.addField((AbstractField)new Field(fieldStr, DataType.STRING));
            this.m_Report.addParameter(fieldStr, cell.getContent());
        }
        if (this.getID().length() == 0) {
            this.setID("" + row.toString().hashCode());
        }
    }

    public boolean hasReport() {
        return true;
    }

    public void setReport(Report value) {
        this.m_Report = value;
    }

    public Report getReport() {
        return this.m_Report;
    }

    public Row toRow() {
        DenseDataRow result = null;
        if (this.hasDatasetHeader()) {
            result = new DenseDataRow();
            result.setOwner(this.m_DatasetHeader);
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SpreadSheetRowPoint point = (SpreadSheetRowPoint)((Object)iterator.next());
                if (point.getX() >= this.m_DatasetHeader.getColumnCount()) continue;
                result.addCell(point.getX().intValue()).setContent(point.getY());
            }
        }
        return result;
    }

    public Notes getNotes() {
        return this.m_Notes;
    }

    public SpreadSheet toSpreadSheet() {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        result.setName(this.getID());
        HeaderRow row = result.getHeaderRow();
        row.addCell("C").setContent("Column");
        row.addCell("V").setContent("Value");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            SpreadSheetRowPoint point = (SpreadSheetRowPoint)((Object)iter.next());
            row = result.addRow();
            row.addCell("C").setContent(point.getX());
            row.addCell("V").setContent(point.getY());
        }
        return result;
    }
}

