/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet;

import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ColorContainer;
import adams.gui.visualization.container.NamedContainer;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.spreadsheet.SpreadSheetRow;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainerManager;
import java.awt.Color;

public class SpreadSheetRowContainer
extends AbstractContainer
implements ColorContainer,
VisibilityContainer,
NamedContainer {
    private static final long serialVersionUID = 7952799099277106479L;
    protected Color m_Color;
    protected boolean m_Visible;

    public SpreadSheetRowContainer(SpreadSheetRowContainerManager manager, SpreadSheetRow data) {
        super((AbstractContainerManager)manager, (Comparable)((Object)data));
    }

    protected void initialize() {
        super.initialize();
        this.m_Color = Color.WHITE;
        this.m_Visible = true;
    }

    public void assign(SpreadSheetRowContainer c) {
        super.assign((AbstractContainer)c);
        this.m_Updating = true;
        this.setColor(c.getColor());
        this.setVisible(c.isVisible());
        this.m_Updating = false;
    }

    public void setColor(Color value) {
        this.m_Color = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.UPDATE, this.getManager().indexOf((AbstractContainer)this)));
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    public void setVisible(boolean value) {
        this.m_Visible = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.VISIBILITY, this.getManager().indexOf((AbstractContainer)this)));
        }
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    public void setData(SpreadSheetRow value) {
        this.setPayload((Comparable)((Object)value));
    }

    public SpreadSheetRow getData() {
        return (SpreadSheetRow)((Object)this.getPayload());
    }

    public void setID(String value) {
        this.getData().setID(value);
    }

    public String getID() {
        return this.getData().getID();
    }

    public String getDisplayID() {
        return this.getID().replaceAll("-weka\\.filter.*", "");
    }

    public int compareTo(AbstractContainer o) {
        if (o == null) {
            return 1;
        }
        SpreadSheetRowContainer c = (SpreadSheetRowContainer)o;
        return this.getData().compareTo((Object)c.getData());
    }

    public int hashCode() {
        return this.getData().hashCode();
    }

    public String toString() {
        return this.getData().toString();
    }
}

