/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet;

import adams.data.container.DataContainerUtils;
import adams.gui.visualization.spreadsheet.SpreadSheetRow;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPoint;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPointComparator;
import java.util.Collections;
import java.util.List;

public class SpreadSheetRowUtils
extends DataContainerUtils {
    protected static SpreadSheetRowPointComparator m_Comparator = new SpreadSheetRowPointComparator(false, true);

    public static SpreadSheetRowPointComparator getComparator() {
        return m_Comparator;
    }

    public static int findX(List<SpreadSheetRowPoint> points, SpreadSheetRowPoint p) {
        int result = Collections.binarySearch(points, p, m_Comparator);
        if (result < 0) {
            result = -1;
        }
        return result;
    }

    public static int findX(List<SpreadSheetRowPoint> points, int x) {
        return SpreadSheetRowUtils.findX(points, new SpreadSheetRowPoint(x, 0.0));
    }

    public static int findClosestX(List<SpreadSheetRowPoint> points, int x) {
        int result = -1;
        if (points.size() == 0) {
            return result;
        }
        int index = Collections.binarySearch(points, new SpreadSheetRowPoint(x, 0.0), m_Comparator);
        if (index < 0) {
            if ((index = -index) >= points.size()) {
                index = points.size() - 1;
            }
            result = index;
            double dist = Math.abs((double)x - points.get(index).getX().doubleValue());
            for (int i = index - 2; i <= index + 2; ++i) {
                SpreadSheetRowPoint currPoint;
                double currDist;
                if (i < 0 || i >= points.size() || !((currDist = Math.abs((double)x - (currPoint = points.get(i)).getX().doubleValue())) < dist)) continue;
                dist = currDist;
                result = i;
            }
        } else {
            result = index;
        }
        return result;
    }

    public static int[] findEnclosingXs(List<SpreadSheetRowPoint> points, int x) {
        int[] result = new int[]{-1, -1};
        int index = SpreadSheetRowUtils.findClosestX(points, x);
        if (index > -1) {
            if (points.get(index).getX().doubleValue() <= (double)x) {
                result[0] = index;
                if (index < points.size() - 1) {
                    result[1] = index + 1;
                }
            } else if (points.get(index).getX().doubleValue() > (double)x) {
                result[1] = index;
                if (index > 0) {
                    result[0] = index - 1;
                }
            }
        }
        return result;
    }

    public static double[] toDoubleArray(SpreadSheetRow r) {
        return SpreadSheetRowUtils.toDoubleArray(r.toList());
    }

    public static double[] toDoubleArray(List<SpreadSheetRowPoint> data) {
        double[] result = new double[data.size()];
        int i = 0;
        for (SpreadSheetRowPoint p : data) {
            result[i++] = new Double(p.getY());
        }
        return result;
    }
}

