/* The following code was generated by JFlex 1.4.3 on 12/10/21 2:19 PM */

/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/*
 * Scanner.java
 * Copyright (C) 2016 University of Waikato, Hamilton, New Zealand
 */

package adams.parser.lookupupdate;

import java_cup.runtime.SymbolFactory;
import java.io.*;

/**
 * A scanner for lookup update rules.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 */

public class Scanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\56\1\55\1\0\1\56\1\63\22\0\1\56\1\46\1\61"+
    "\2\0\1\23\1\0\1\54\1\57\1\60\1\20\1\17\1\15\1\16"+
    "\1\50\1\21\1\34\1\33\1\37\7\47\1\12\1\14\1\44\1\13"+
    "\1\45\2\0\1\24\1\25\1\30\1\11\1\5\1\2\1\32\1\4"+
    "\1\1\2\51\1\7\1\42\1\6\1\31\1\36\1\26\1\27\1\10"+
    "\1\3\1\41\1\51\1\43\1\35\1\40\1\51\1\52\1\62\1\53"+
    "\1\22\1\51\1\0\1\24\1\25\1\30\1\11\1\5\1\2\1\32"+
    "\1\4\1\1\2\51\1\7\1\42\1\6\1\31\1\36\1\26\1\27"+
    "\1\10\1\3\1\41\1\51\1\43\1\35\1\40\1\51\uff85\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\11\2\1\1\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\4\2\1\14\3\2"+
    "\1\15\1\16\1\1\1\2\2\1\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\22\2\1\27\1\3"+
    "\1\30\11\2\1\31\5\2\1\32\1\33\1\34\1\14"+
    "\2\0\1\35\1\36\1\37\1\40\4\2\1\41\2\2"+
    "\1\42\1\2\1\43\1\2\1\44\1\45\1\2\1\46"+
    "\1\47\1\2\1\50\1\2\1\51\3\2\1\52\1\53"+
    "\1\54\6\2\1\55\1\2\1\14\1\56\1\2\1\57"+
    "\1\60\1\2\1\61\1\62\1\63\1\64\2\2\1\65"+
    "\1\66\1\67\1\70\1\2\1\71\1\72\3\2\1\73"+
    "\1\2\1\74\1\2\1\75\1\76\1\2\1\77\1\2"+
    "\1\100\1\101\2\2\1\102\3\2\1\103\1\104\1\105"+
    "\1\2\1\106\1\107\2\2\1\110\1\111\3\2\1\56"+
    "\1\112\1\2\1\46\1\2\1\113\1\2\1\114\7\2"+
    "\1\115\3\2\1\116\3\2\1\117\2\2\1\107\3\2"+
    "\1\112\1\120\1\121\1\2\1\122";

  private static int [] zzUnpackAction() {
    int [] result = new int[211];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\64\0\150\0\234\0\320\0\u0104\0\u0138\0\u016c"+
    "\0\u01a0\0\u01d4\0\u0208\0\u023c\0\u0270\0\u02a4\0\150\0\150"+
    "\0\u02d8\0\150\0\150\0\u030c\0\150\0\150\0\u0340\0\u0374"+
    "\0\u03a8\0\u03dc\0\u0410\0\u0444\0\u0478\0\u04ac\0\u04e0\0\u0514"+
    "\0\u0548\0\u057c\0\u05b0\0\u05e4\0\150\0\150\0\150\0\150"+
    "\0\u0618\0\150\0\u064c\0\u023c\0\u0680\0\u06b4\0\u06e8\0\u071c"+
    "\0\u0750\0\u0784\0\u07b8\0\u07ec\0\u0820\0\u0854\0\u0888\0\u08bc"+
    "\0\u08f0\0\u0924\0\u0958\0\u098c\0\u09c0\0\u09f4\0\150\0\150"+
    "\0\u0a28\0\u0a5c\0\u0a90\0\u0ac4\0\u0af8\0\u0b2c\0\u0b60\0\u0b94"+
    "\0\u0bc8\0\u0bfc\0\u023c\0\u0c30\0\u0c64\0\u0c98\0\u0ccc\0\u0d00"+
    "\0\150\0\150\0\150\0\u0d34\0\u0d68\0\u0d9c\0\150\0\150"+
    "\0\150\0\150\0\u0dd0\0\u0e04\0\u0e38\0\u0e6c\0\u0ea0\0\u0ed4"+
    "\0\u0f08\0\u023c\0\u0f3c\0\u023c\0\u0f70\0\u023c\0\u023c\0\u0fa4"+
    "\0\u0fd8\0\u100c\0\u1040\0\u1074\0\u10a8\0\u023c\0\u10dc\0\u1110"+
    "\0\u1144\0\u023c\0\u023c\0\u023c\0\u1178\0\u11ac\0\u11e0\0\u1214"+
    "\0\u1248\0\u127c\0\u12b0\0\u12e4\0\u1318\0\u134c\0\u1380\0\u023c"+
    "\0\u023c\0\u13b4\0\u023c\0\150\0\150\0\u023c\0\u13e8\0\u141c"+
    "\0\u023c\0\u023c\0\u023c\0\u023c\0\u1450\0\u023c\0\u023c\0\u1484"+
    "\0\u14b8\0\u14ec\0\u023c\0\u1520\0\u023c\0\u1554\0\u1588\0\u023c"+
    "\0\u15bc\0\u023c\0\u15f0\0\u023c\0\u023c\0\u1624\0\u1658\0\u023c"+
    "\0\u168c\0\u16c0\0\u16f4\0\u023c\0\u023c\0\u023c\0\u1728\0\u023c"+
    "\0\u175c\0\u1790\0\u17c4\0\u023c\0\u023c\0\u17f8\0\u182c\0\u1860"+
    "\0\u023c\0\u1894\0\u18c8\0\u023c\0\u18fc\0\u023c\0\u1930\0\u023c"+
    "\0\u1964\0\u1998\0\u19cc\0\u1a00\0\u1a34\0\u1a68\0\u1a9c\0\u1ad0"+
    "\0\u1b04\0\u1b38\0\u1b6c\0\u023c\0\u1ba0\0\u1bd4\0\u1c08\0\u023c"+
    "\0\u1c3c\0\u1c70\0\u023c\0\u1ca4\0\u1cd8\0\u1d0c\0\u023c\0\u023c"+
    "\0\u023c\0\u1d40\0\u023c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[211];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12"+
    "\1\13\1\14\1\15\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\2\14\1\30\1\31"+
    "\1\32\1\14\2\33\1\14\1\34\1\33\1\14\1\35"+
    "\1\36\1\14\1\37\1\40\1\41\1\33\1\42\1\14"+
    "\1\43\1\3\1\44\2\45\1\46\1\47\1\50\1\3"+
    "\1\45\55\51\1\0\3\51\1\52\1\53\1\3\65\0"+
    "\1\14\1\54\7\14\4\0\1\14\5\0\20\14\3\0"+
    "\3\14\13\0\1\55\5\14\1\56\2\14\4\0\1\14"+
    "\5\0\1\57\17\14\3\0\3\14\13\0\3\14\1\60"+
    "\5\14\4\0\1\14\5\0\1\61\2\14\1\62\14\14"+
    "\3\0\3\14\13\0\11\14\4\0\1\14\5\0\1\63"+
    "\13\14\1\64\3\14\3\0\3\14\13\0\5\14\1\65"+
    "\1\66\2\14\4\0\1\14\5\0\11\14\1\67\6\14"+
    "\3\0\3\14\13\0\11\14\4\0\1\14\5\0\5\14"+
    "\1\70\12\14\3\0\3\14\13\0\4\14\1\71\4\14"+
    "\4\0\1\14\5\0\5\14\1\72\12\14\3\0\3\14"+
    "\13\0\1\73\1\14\1\74\6\14\4\0\1\14\5\0"+
    "\2\14\1\75\12\14\1\76\2\14\3\0\3\14\13\0"+
    "\11\14\4\0\1\14\5\0\20\14\3\0\3\14\25\0"+
    "\1\77\63\0\1\100\51\0\11\14\4\0\1\14\5\0"+
    "\7\14\2\33\2\14\1\33\4\14\3\0\1\33\1\42"+
    "\1\14\33\0\1\101\43\0\2\14\1\102\2\14\1\103"+
    "\1\104\2\14\4\0\1\14\5\0\1\14\1\105\16\14"+
    "\3\0\3\14\13\0\1\106\3\14\1\107\4\14\4\0"+
    "\1\14\5\0\20\14\3\0\3\14\13\0\4\14\1\110"+
    "\4\14\4\0\1\14\5\0\1\14\1\111\3\14\1\112"+
    "\12\14\3\0\3\14\13\0\11\14\4\0\1\14\5\0"+
    "\3\14\1\113\14\14\3\0\3\14\13\0\4\14\1\114"+
    "\4\14\4\0\1\14\5\0\7\14\2\33\2\14\1\33"+
    "\4\14\3\0\1\33\1\42\1\14\13\0\11\14\4\0"+
    "\1\14\5\0\5\14\1\115\12\14\3\0\3\14\13\0"+
    "\11\14\4\0\1\14\5\0\12\14\1\116\5\14\3\0"+
    "\3\14\13\0\1\117\10\14\4\0\1\14\5\0\1\120"+
    "\17\14\3\0\3\14\25\0\1\121\31\0\1\122\31\0"+
    "\1\123\63\0\1\122\51\0\11\14\4\0\1\14\5\0"+
    "\7\14\2\124\2\14\1\124\4\14\3\0\1\124\2\14"+
    "\12\0\53\125\1\0\10\125\54\126\1\0\7\126\55\51"+
    "\1\0\3\51\6\0\1\127\2\0\1\130\20\0\1\131"+
    "\31\0\1\132\3\0\5\14\1\133\3\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\5\14\1\134\12\14\3\0\3\14\13\0\6\14"+
    "\1\135\2\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\4\14\1\136\4\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\5\14\1\137\3\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\1\140\10\14\4\0"+
    "\1\14\5\0\15\14\1\141\2\14\3\0\3\14\13\0"+
    "\7\14\1\142\1\14\4\0\1\14\5\0\20\14\3\0"+
    "\3\14\13\0\11\14\4\0\1\14\5\0\12\14\1\143"+
    "\5\14\3\0\3\14\13\0\10\14\1\144\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\7\14\1\145\1\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\11\14"+
    "\4\0\1\14\5\0\12\14\1\146\5\14\3\0\3\14"+
    "\13\0\2\14\1\147\6\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\1\14\1\150\3\14\1\151\3\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\11\14"+
    "\4\0\1\14\5\0\6\14\1\152\10\14\1\153\3\0"+
    "\3\14\13\0\5\14\1\154\3\14\4\0\1\14\5\0"+
    "\6\14\1\155\11\14\3\0\3\14\13\0\11\14\4\0"+
    "\1\14\5\0\3\14\1\156\14\14\3\0\3\14\13\0"+
    "\11\14\4\0\1\14\5\0\3\14\1\157\14\14\3\0"+
    "\3\14\13\0\11\14\4\0\1\14\5\0\1\14\1\160"+
    "\16\14\3\0\3\14\12\0\55\101\1\0\6\101\1\0"+
    "\11\14\4\0\1\14\5\0\1\161\17\14\3\0\3\14"+
    "\13\0\10\14\1\162\4\0\1\14\5\0\20\14\3\0"+
    "\3\14\13\0\6\14\1\163\2\14\4\0\1\14\5\0"+
    "\20\14\3\0\3\14\13\0\7\14\1\164\1\14\4\0"+
    "\1\14\5\0\20\14\3\0\3\14\13\0\5\14\1\165"+
    "\3\14\4\0\1\14\5\0\6\14\1\166\11\14\3\0"+
    "\3\14\13\0\11\14\4\0\1\14\5\0\12\14\1\167"+
    "\5\14\3\0\3\14\13\0\1\170\10\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\3\14\1\171\14\14\3\0\3\14\13\0\5\14"+
    "\1\172\1\14\1\173\1\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\11\14\4\0\1\174\5\0\7\14"+
    "\1\175\3\14\1\175\4\14\3\0\1\175\2\14\13\0"+
    "\11\14\4\0\1\14\5\0\17\14\1\176\3\0\3\14"+
    "\13\0\11\14\4\0\1\14\5\0\12\14\1\177\5\14"+
    "\3\0\3\14\13\0\5\14\1\200\2\14\1\201\4\0"+
    "\1\14\5\0\20\14\3\0\3\14\13\0\2\14\1\202"+
    "\6\14\4\0\1\14\5\0\11\14\1\203\6\14\3\0"+
    "\3\14\13\0\4\14\1\114\4\14\4\0\1\14\5\0"+
    "\7\14\2\124\2\14\1\124\4\14\3\0\1\124\2\14"+
    "\12\0\53\125\1\204\10\125\54\126\1\205\7\126\1\0"+
    "\10\14\1\206\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\11\14\4\0\1\14\5\0\5\14\1\207\12\14"+
    "\3\0\3\14\13\0\7\14\1\210\1\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\5\14\1\211\3\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\3\14"+
    "\1\212\5\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\11\14\4\0\1\14\5\0\16\14\1\213\1\14"+
    "\3\0\3\14\13\0\4\14\1\214\4\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\5\14\1\215\12\14\3\0\3\14\13\0\4\14"+
    "\1\216\4\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\2\14\1\217\6\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\11\14\4\0\1\14\5\0\6\14"+
    "\1\220\11\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\7\14\1\221\10\14\3\0\3\14\13\0\4\14"+
    "\1\222\4\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\3\14\1\223\5\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\5\14\1\224\3\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\2\14\1\225\6\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\7\14"+
    "\1\226\1\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\5\14\1\227\3\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\2\14\1\230\6\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\3\14\1\231\5\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\2\14"+
    "\1\232\3\14\1\233\2\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\6\14\1\234\2\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\2\14\1\235\6\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\2\14"+
    "\1\236\6\14\4\0\1\14\5\0\4\14\1\237\13\14"+
    "\3\0\3\14\13\0\3\14\1\240\5\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\7\14\1\175\3\14\1\175\4\14\3\0\1\175"+
    "\2\14\13\0\11\14\4\0\1\14\5\0\7\14\2\175"+
    "\2\14\1\175\4\14\3\0\1\175\2\14\13\0\4\14"+
    "\1\241\4\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\4\14\1\242\4\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\11\14\4\0\1\14\5\0\4\14"+
    "\1\243\13\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\3\14\1\244\14\14\3\0\3\14\13\0\4\14"+
    "\1\245\4\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\2\14\1\246\6\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\2\14\1\247\6\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\10\14\1\250\7\14\3\0\3\14\13\0\11\14"+
    "\4\0\1\14\5\0\3\14\1\251\14\14\3\0\3\14"+
    "\13\0\11\14\4\0\1\14\5\0\15\14\1\252\2\14"+
    "\3\0\3\14\13\0\2\14\1\253\6\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\13\14\1\254\4\14\3\0\3\14\13\0\2\14"+
    "\1\255\6\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\11\14\4\0\1\14\5\0\1\256\17\14\3\0"+
    "\3\14\13\0\11\14\4\0\1\14\5\0\1\257\17\14"+
    "\3\0\3\14\13\0\11\14\4\0\1\14\5\0\1\260"+
    "\17\14\3\0\3\14\13\0\11\14\4\0\1\14\5\0"+
    "\3\14\1\261\14\14\3\0\3\14\13\0\11\14\4\0"+
    "\1\14\5\0\3\14\1\262\14\14\3\0\3\14\13\0"+
    "\3\14\1\263\5\14\4\0\1\14\5\0\20\14\3\0"+
    "\3\14\13\0\3\14\1\264\5\14\4\0\1\14\5\0"+
    "\20\14\3\0\3\14\13\0\11\14\4\0\1\14\5\0"+
    "\4\14\1\265\13\14\3\0\3\14\13\0\11\14\4\0"+
    "\1\14\5\0\16\14\1\266\1\14\3\0\3\14\13\0"+
    "\1\267\10\14\4\0\1\14\5\0\3\14\1\270\14\14"+
    "\3\0\3\14\13\0\11\14\4\0\1\14\5\0\4\14"+
    "\1\271\13\14\3\0\3\14\13\0\1\272\10\14\4\0"+
    "\1\14\5\0\20\14\3\0\3\14\13\0\2\14\1\273"+
    "\6\14\4\0\1\14\5\0\20\14\3\0\3\14\13\0"+
    "\11\14\4\0\1\14\5\0\4\14\1\274\13\14\3\0"+
    "\3\14\13\0\4\14\1\275\4\14\4\0\1\14\5\0"+
    "\20\14\3\0\3\14\13\0\11\14\4\0\1\14\5\0"+
    "\1\276\17\14\3\0\3\14\13\0\2\14\1\277\6\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\4\14"+
    "\1\300\4\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\5\14\1\301\3\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\4\14\1\302\4\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\11\14\4\0\1\14"+
    "\5\0\1\303\17\14\3\0\3\14\13\0\7\14\1\304"+
    "\1\14\4\0\1\14\5\0\20\14\3\0\3\14\13\0"+
    "\7\14\1\305\1\14\4\0\1\14\5\0\20\14\3\0"+
    "\3\14\13\0\11\14\4\0\1\14\5\0\15\14\1\306"+
    "\2\14\3\0\3\14\13\0\11\14\4\0\1\14\5\0"+
    "\1\307\17\14\3\0\3\14\13\0\7\14\1\310\1\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\5\14"+
    "\1\311\3\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\7\14\1\312\1\14\4\0\1\14\5\0\20\14"+
    "\3\0\3\14\13\0\4\14\1\313\4\14\4\0\1\14"+
    "\5\0\20\14\3\0\3\14\13\0\2\14\1\314\6\14"+
    "\4\0\1\14\5\0\20\14\3\0\3\14\13\0\6\14"+
    "\1\315\2\14\4\0\1\14\5\0\20\14\3\0\3\14"+
    "\13\0\11\14\4\0\1\14\5\0\1\316\17\14\3\0"+
    "\3\14\13\0\4\14\1\317\4\14\4\0\1\14\5\0"+
    "\20\14\3\0\3\14\13\0\4\14\1\320\4\14\4\0"+
    "\1\14\5\0\20\14\3\0\3\14\13\0\6\14\1\321"+
    "\2\14\4\0\1\14\5\0\20\14\3\0\3\14\13\0"+
    "\2\14\1\322\6\14\4\0\1\14\5\0\20\14\3\0"+
    "\3\14\13\0\4\14\1\323\4\14\4\0\1\14\5\0"+
    "\20\14\3\0\3\14\12\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[7540];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\11\13\1\2\11\1\1\2\11\1\1\2\11"+
    "\16\1\4\11\1\1\1\11\24\1\2\11\20\1\3\11"+
    "\1\1\2\0\4\11\51\1\2\11\116\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[211];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  // Author: FracPete (fracpete at waikato dot ac dot nz)
  protected SymbolFactory sf;

  public Scanner(InputStream r, SymbolFactory sf){
    this(r);
    this.sf = sf;
  }
  StringBuilder string = new StringBuilder();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 178) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 60: 
          { return sf.newSymbol("Sqrt", sym.SQRT);
          }
        case 83: break;
        case 24: 
          { /* ignore line comments. */
          }
        case 84: break;
        case 2: 
          { return sf.newSymbol("Variable", sym.VARIABLE, new String(yytext()));
          }
        case 85: break;
        case 26: 
          { return sf.newSymbol("Less or equal than", sym.LE);
          }
        case 86: break;
        case 28: 
          { return sf.newSymbol("Greater or equal than", sym.GE);
          }
        case 87: break;
        case 14: 
          { return sf.newSymbol("Greater than", sym.GT);
          }
        case 88: break;
        case 36: 
          { return sf.newSymbol("Exp", sym.EXP);
          }
        case 89: break;
        case 11: 
          { return sf.newSymbol("Modulo", sym.MODULO);
          }
        case 90: break;
        case 69: 
          { return sf.newSymbol("Hypot", sym.HYPOT);
          }
        case 91: break;
        case 63: 
          { return sf.newSymbol("repeat", sym.REPEAT);
          }
        case 92: break;
        case 64: 
          { return sf.newSymbol("Ceil", sym.CEIL);
          }
        case 93: break;
        case 43: 
          { return sf.newSymbol("All", sym.ALL);
          }
        case 94: break;
        case 51: 
          { return sf.newSymbol("Variable", sym.VARIABLE, new String(yytext().replace("'", "").replace("'", "")));
          }
        case 95: break;
        case 68: 
          { return sf.newSymbol("False", sym.FALSE);
          }
        case 96: break;
        case 40: 
          { return sf.newSymbol("Sin", sym.SIN);
          }
        case 97: break;
        case 30: 
          { string.append('\n');
          }
        case 98: break;
        case 49: 
          { return sf.newSymbol("Max", sym.MAX);
          }
        case 99: break;
        case 32: 
          { string.append('\"');
          }
        case 100: break;
        case 15: 
          { /* ignore white space. */
          }
        case 101: break;
        case 10: 
          { return sf.newSymbol("Power", sym.EXPONENT);
          }
        case 102: break;
        case 47: 
          { return sf.newSymbol("Min", sym.MIN);
          }
        case 103: break;
        case 79: 
          { return sf.newSymbol("Contains", sym.CONTAINS);
          }
        case 104: break;
        case 72: 
          { return sf.newSymbol("Atan2", sym.ATAN2);
          }
        case 105: break;
        case 55: 
          { return sf.newSymbol("Trim", sym.TRIM);
          }
        case 106: break;
        case 65: 
          { return sf.newSymbol("Cbrt", sym.CBRT);
          }
        case 107: break;
        case 44: 
          { return sf.newSymbol("Abs", sym.ABS);
          }
        case 108: break;
        case 20: 
          { yybegin(YYINITIAL);
                  return sf.newSymbol("String", sym.STRING, string.toString());
          }
        case 109: break;
        case 50: 
          { return sf.newSymbol("Variable", sym.VARIABLE, new String(yytext().replace("[", "").replace("]", "")));
          }
        case 110: break;
        case 31: 
          { string.append('\r');
          }
        case 111: break;
        case 70: 
          { return sf.newSymbol("Log10", sym.LOG10);
          }
        case 112: break;
        case 39: 
          { return sf.newSymbol("Log", sym.LOG);
          }
        case 113: break;
        case 18: 
          { string.setLength(0); yybegin(STRING);
          }
        case 114: break;
        case 81: 
          { return sf.newSymbol("ReplaceAll", sym.REPLACEALL);
          }
        case 115: break;
        case 78: 
          { return sf.newSymbol("Matches", sym.MATCHES);
          }
        case 116: break;
        case 41: 
          { return sf.newSymbol("str", sym.STR);
          }
        case 117: break;
        case 48: 
          { return sf.newSymbol("Mid", sym.MID);
          }
        case 118: break;
        case 67: 
          { return sf.newSymbol("Floor", sym.FLOOR);
          }
        case 119: break;
        case 66: 
          { return sf.newSymbol("CosH", sym.COSH);
          }
        case 120: break;
        case 6: 
          { return sf.newSymbol("Minus", sym.MINUS);
          }
        case 121: break;
        case 29: 
          { string.append('\t');
          }
        case 122: break;
        case 75: 
          { return sf.newSymbol("Signum", sym.SIGNUM);
          }
        case 123: break;
        case 5: 
          { return sf.newSymbol("Comma", sym.COMMA);
          }
        case 124: break;
        case 9: 
          { return sf.newSymbol("Division", sym.DIVISION);
          }
        case 125: break;
        case 57: 
          { return sf.newSymbol("Else", sym.ELSE);
          }
        case 126: break;
        case 56: 
          { return sf.newSymbol("True", sym.TRUE);
          }
        case 127: break;
        case 53: 
          { return sf.newSymbol("Then", sym.THEN);
          }
        case 128: break;
        case 27: 
          { return sf.newSymbol("Not qquals", sym.NOT_EQ);
          }
        case 129: break;
        case 19: 
          { string.append(yytext());
          }
        case 130: break;
        case 82: 
          { return sf.newSymbol("Concantenate", sym.CONCATENATE);
          }
        case 131: break;
        case 1: 
          { System.err.println("Illegal character: "+yytext());
          }
        case 132: break;
        case 35: 
          { return sf.newSymbol("End",  sym.END);
          }
        case 133: break;
        case 38: 
          { return sf.newSymbol("Length", sym.LENGTH);
          }
        case 134: break;
        case 7: 
          { return sf.newSymbol("Plus", sym.PLUS);
          }
        case 135: break;
        case 13: 
          { return sf.newSymbol("Less than", sym.LT);
          }
        case 136: break;
        case 80: 
          { return sf.newSymbol("Substitute", sym.SUBSTITUTE);
          }
        case 137: break;
        case 12: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(yytext()));
          }
        case 138: break;
        case 16: 
          { return sf.newSymbol("Left Bracket", sym.LPAREN);
          }
        case 139: break;
        case 23: 
          { return sf.newSymbol("Assignment", sym.ASSIGNMENT);
          }
        case 140: break;
        case 76: 
          { return sf.newSymbol("Substr", sym.SUBSTR);
          }
        case 141: break;
        case 62: 
          { return sf.newSymbol("Rint", sym.RINT);
          }
        case 142: break;
        case 33: 
          { return sf.newSymbol("Tan", sym.TAN);
          }
        case 143: break;
        case 46: 
          { return sf.newSymbol("Pow", sym.POW);
          }
        case 144: break;
        case 34: 
          { return sf.newSymbol("Has", sym.HAS);
          }
        case 145: break;
        case 25: 
          { return sf.newSymbol("Or", sym.OR);
          }
        case 146: break;
        case 54: 
          { return sf.newSymbol("TanH", sym.TANH);
          }
        case 147: break;
        case 21: 
          { string.append('\\');
          }
        case 148: break;
        case 77: 
          { return sf.newSymbol("Replace", sym.REPLACE);
          }
        case 149: break;
        case 42: 
          { return sf.newSymbol("And", sym.AND);
          }
        case 150: break;
        case 59: 
          { return sf.newSymbol("SinH", sym.SINH);
          }
        case 151: break;
        case 58: 
          { return sf.newSymbol("Left", sym.LEFT);
          }
        case 152: break;
        case 73: 
          { return sf.newSymbol("Right", sym.RIGHT);
          }
        case 153: break;
        case 74: 
          { return sf.newSymbol("UpperCase", sym.UPPERCASE);
          }
        case 154: break;
        case 4: 
          { return sf.newSymbol("Semi", sym.SEMI);
          }
        case 155: break;
        case 37: 
          { return sf.newSymbol("Not", sym.NOT);
          }
        case 156: break;
        case 17: 
          { return sf.newSymbol("Right Bracket", sym.RPAREN);
          }
        case 157: break;
        case 8: 
          { return sf.newSymbol("Times", sym.TIMES);
          }
        case 158: break;
        case 22: 
          { return sf.newSymbol("If",   sym.IF);
          }
        case 159: break;
        case 52: 
          { return sf.newSymbol("Find", sym.FIND);
          }
        case 160: break;
        case 61: 
          { return sf.newSymbol("Atan", sym.ATAN);
          }
        case 161: break;
        case 71: 
          { return sf.newSymbol("LowerCase", sym.LOWERCASE);
          }
        case 162: break;
        case 45: 
          { return sf.newSymbol("Cos", sym.COS);
          }
        case 163: break;
        case 3: 
          { return sf.newSymbol("Equals", sym.EQ);
          }
        case 164: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {     return sf.newSymbol("EOF",sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
