/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.ReportToSpreadSheet;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.report.Report;
import adams.env.Environment;
import adams.test.TmpFile;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ReportToSpreadSheetTest
extends AbstractConversionTestCase {
    public ReportToSpreadSheetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("simple.report");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("simple.report");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        ArrayList result;
        TmpFile file = new TmpFile("simple.report");
        DefaultSimpleReportReader reader = new DefaultSimpleReportReader();
        reader.setInput((PlaceholderFile)file);
        try {
            result = reader.read();
        }
        catch (Exception e) {
            result = new ArrayList();
            ReportToSpreadSheetTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result.toArray(new Report[result.size()]);
    }

    protected Conversion[] getRegressionSetups() {
        ReportToSpreadSheet[] result = new ReportToSpreadSheet[]{new ReportToSpreadSheet()};
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(ReportToSpreadSheetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ReportToSpreadSheetTest.runTest((Test)ReportToSpreadSheetTest.suite());
    }
}

