/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.UnorderedRange;
import adams.core.UnorderedRangeTest;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUnorderedColumnRange;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetUnorderedColumnRangeTest
extends UnorderedRangeTest {
    protected SpreadSheet m_Sheet;

    public SpreadSheetUnorderedColumnRangeTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/core/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "simple.csv";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Sheet = new CsvSpreadSheetReader().read((File)new TmpFile(filename));
        if (this.m_Sheet == null) {
            throw new FileNotFoundException("Test file '" + filename + "' not found?");
        }
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("simple.csv");
        super.tearDown();
    }

    protected UnorderedRange newRange(String index, int max) {
        if (index == null) {
            return new SpreadSheetUnorderedColumnRange();
        }
        return new SpreadSheetUnorderedColumnRange(index, max);
    }

    public void testColumnNames() {
        SpreadSheetUnorderedColumnRange range = new SpreadSheetUnorderedColumnRange("first-last");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"first-last", (String)range.getRange());
        range.setSpreadSheet(null);
        range.setRange("blah");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should contain no indices", (int)0, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"blah", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("Field");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"Field", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Field\"");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"\"Field\"", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("field");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should not be valid", (int)0, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should not be same", (String)"field", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("Feild");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"Feild", (String)range.getRange());
        range.setSpreadSheet(null);
        range.setRange("Field-Value");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"Field-Value", (String)range.getRange());
        range.setSpreadSheet(null);
        range.setRange("Value,Field");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"Value,Field", (String)range.getRange());
        range.setSpreadSheet(null);
        range.setRange("\"Field\"-\"Value\"");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be invalid", (int)0, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"\"Field\"-\"Value\"", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("Field-Value");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)3, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"Field-Value", (String)range.getRange());
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices()[1]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices()[2]);
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("Value,Field");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"Value,Field", (String)range.getRange());
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[1]);
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Field\"-\"Value\"");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)3, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"\"Field\"-\"Value\"", (String)range.getRange());
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)0, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices()[1]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices()[2]);
    }

    public void testSpecialColumnNames() {
        SpreadSheetUnorderedColumnRange range = new SpreadSheetUnorderedColumnRange();
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Hyphen-ated\"");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)3, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"\"Hyphen-ated\"", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Under_score\"");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)5, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"\"Under_score\"", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Com,ma\"");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)1, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)4, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"\"Com,ma\"", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Hyphen-ated\",\"Com,ma\"");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)3, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)4, (int)range.getIntIndices()[1]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"\"Hyphen-ated\",\"Com,ma\"", (String)range.getRange());
        range.setSpreadSheet(this.m_Sheet);
        range.setRange("\"Hyphen-ated\",\"Under_score\"");
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)2, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)3, (int)range.getIntIndices()[0]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be valid", (int)5, (int)range.getIntIndices()[1]);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"should be same", (String)"\"Hyphen-ated\",\"Under_score\"", (String)range.getRange());
    }

    public void testSubstrings() {
        DefaultSpreadSheet sheet = new DefaultSpreadSheet();
        sheet.getHeaderRow().addCell("0").setContent("blah");
        sheet.getHeaderRow().addCell("1").setContent("dbtimestamp");
        sheet.getHeaderRow().addCell("2").setContent("time");
        SpreadSheetUnorderedColumnRange range = new SpreadSheetUnorderedColumnRange();
        range.setRange("bloerk");
        range.setData((Object)sheet);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"shouldn't find any cols", (int)0, (int)range.getIntIndices().length);
        range = new SpreadSheetUnorderedColumnRange();
        range.setRange("dbtimestamp");
        range.setData((Object)sheet);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"index differs", (int)1, (int)range.getIntIndices()[0]);
        range = new SpreadSheetUnorderedColumnRange();
        range.setRange("time");
        range.setData((Object)sheet);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"index differs", (int)2, (int)range.getIntIndices()[0]);
        range = new SpreadSheetUnorderedColumnRange();
        range.setRange("blah");
        range.setData((Object)sheet);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"# indices differs", (int)1, (int)range.getIntIndices().length);
        SpreadSheetUnorderedColumnRangeTest.assertEquals((String)"index differs", (int)0, (int)range.getIntIndices()[0]);
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetUnorderedColumnRangeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetUnorderedColumnRangeTest.runTest((Test)SpreadSheetUnorderedColumnRangeTest.suite());
    }
}

