/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.JAIImageWriter;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.JFreeChartFileWriter;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.gui.visualization.jfreechart.chart.AbstractChartGenerator;
import adams.gui.visualization.jfreechart.chart.XYLineChart;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class JFreeChartFileWriterTest
extends AbstractFlowTest {
    public JFreeChartFileWriterTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("sample_nir_spectrum.csv");
        this.m_TestHelper.deleteFileFromTmp("sample_nir_spectrum.png");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("sample_nir_spectrum.csv");
        this.m_TestHelper.deleteFileFromTmp("sample_nir_spectrum.png");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(JFreeChartFileWriterTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/sample_nir_spectrum.csv"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            SpreadSheetFileReader spreadsheetfilereader = new SpreadSheetFileReader();
            CsvSpreadSheetReader csvspreadsheetreader = new CsvSpreadSheetReader();
            DenseDataRow densedatarow = new DenseDataRow();
            csvspreadsheetreader.setDataRowType((DataRow)densedatarow);
            DefaultSpreadSheet defaultspreadsheet = new DefaultSpreadSheet();
            csvspreadsheetreader.setSpreadSheetType((SpreadSheet)defaultspreadsheet);
            spreadsheetfilereader.setReader((SpreadSheetReader)csvspreadsheetreader);
            actors.add(spreadsheetfilereader);
            JFreeChartFileWriter jfreechartfilewriter = new JFreeChartFileWriter();
            argOption = (AbstractArgumentOption)jfreechartfilewriter.getOptionManager().findByProperty("outputFile");
            jfreechartfilewriter.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/sample_nir_spectrum.png"));
            DefaultXY defaultxy = new DefaultXY();
            jfreechartfilewriter.setDataset((AbstractDatasetGenerator)defaultxy);
            XYLineChart xylinechart = new XYLineChart();
            argOption = (AbstractArgumentOption)xylinechart.getOptionManager().findByProperty("labelX");
            xylinechart.setLabelX((String)argOption.valueOf("waveno"));
            argOption = (AbstractArgumentOption)xylinechart.getOptionManager().findByProperty("labelY");
            xylinechart.setLabelY((String)argOption.valueOf("amplitude"));
            jfreechartfilewriter.setChart((AbstractChartGenerator)xylinechart);
            JAIImageWriter jaiimagewriter = new JAIImageWriter();
            jfreechartfilewriter.setWriter((AbstractImageWriter)jaiimagewriter);
            actors.add(jfreechartfilewriter);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            JFreeChartFileWriterTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        JFreeChartFileWriterTest.runTest((Test)JFreeChartFileWriterTest.suite());
    }
}

