/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multispreadsheetoperation;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.multispreadsheetoperation.AbstractMultiSpreadSheetOperation;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.lang.reflect.Array;

public abstract class AbstractMultiSpreadSheetOperationTestCase
extends AdamsTestCase {
    public AbstractMultiSpreadSheetOperationTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/flow/transformer/multispreadsheetoperation/data");
    }

    protected SpreadSheet load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet result = reader.read(new TmpFile(filename).getAbsolutePath());
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractMultiSpreadSheetOperation[] getRegressionSetups();

    protected Object process(SpreadSheet[] data, AbstractMultiSpreadSheetOperation scheme, MessageCollection errors) {
        return scheme.process(data, errors);
    }

    protected String createOutputFilename(String[] input, int no) {
        String ext = "#out" + no;
        Object[] noExt = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            noExt[i] = FileUtils.replaceExtension((String)input[i], (String)"");
        }
        String result = Utils.flatten((Object[])noExt, (String)"#") + ext;
        return result;
    }

    protected boolean save(Object data, String filename) {
        String dataStr;
        if (data.getClass().isArray()) {
            Object[] array = new Object[Array.getLength(data)];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Array.get(data, i);
            }
            dataStr = Utils.flatten((Object[])array, (String)"\n\n");
        } else {
            dataStr = data.toString();
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)dataStr);
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        AbstractMultiSpreadSheetOperation[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        SpreadSheet[] data = new SpreadSheet[input.length];
        for (i = 0; i < input.length; ++i) {
            data[i] = this.load(input[i]);
            AbstractMultiSpreadSheetOperationTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
        }
        for (i = 0; i < setups.length; ++i) {
            AbstractMultiSpreadSheetOperation current = (AbstractMultiSpreadSheetOperation)OptionUtils.shallowCopy((Object)setups[i]);
            AbstractMultiSpreadSheetOperationTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            MessageCollection errors = new MessageCollection();
            Object processed = this.process(data, current, errors);
            AbstractMultiSpreadSheetOperationTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            AbstractMultiSpreadSheetOperationTestCase.assertEquals((String)"Should not have generated errors!", (String)"", (String)errors.toString());
            output[i] = this.createOutputFilename(input, i);
            boolean ok = this.save(processed, output[i]);
            AbstractMultiSpreadSheetOperationTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractMultiSpreadSheetOperationTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        for (i = 0; i < setups.length; ++i) {
            setups[i].destroy();
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

