/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.LenientModeSupporter;
import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.report.Report;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetRowRange;
import java.util.ArrayList;

public class SpreadSheetColumnsToReport
extends AbstractConversion
implements LenientModeSupporter {
    private static final long serialVersionUID = -258589003642261978L;
    protected SpreadSheetColumnIndex m_ColReportNames;
    protected SpreadSheetColumnRange m_ColsReportValues;
    protected SpreadSheetRowRange m_RowsReport;
    protected boolean m_Lenient;

    public String globalInfo() {
        return "Turns spreadsheet columns into reports.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("col-report-names", "colReportNames", (Object)new SpreadSheetColumnIndex());
        this.m_OptionManager.add("cols-report-values", "colsReportValues", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("rows-report", "rowsReport", (Object)new SpreadSheetRowRange());
        this.m_OptionManager.add("lenient", "lenient", (Object)false);
    }

    public void setColReportNames(SpreadSheetColumnIndex value) {
        this.m_ColReportNames = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColReportNames() {
        return this.m_ColReportNames;
    }

    public String colReportNamesTipText() {
        return "The (optional) column that contains the report names.";
    }

    public void setRowsReport(SpreadSheetRowRange value) {
        this.m_RowsReport = value;
        this.reset();
    }

    public SpreadSheetRowRange getRowsReport() {
        return this.m_RowsReport;
    }

    public String rowsReportTipText() {
        return "The rows that contain report.";
    }

    public void setColsReportValues(SpreadSheetColumnRange value) {
        this.m_ColsReportValues = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColsReportValues() {
        return this.m_ColsReportValues;
    }

    public String colsReportValuesTipText() {
        return "The columns to get the report values from.";
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
        this.reset();
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public String lenientTipText() {
        return "If enabled, then errors (e.g., due to corrupt data) will not cause exceptions.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Report[].class;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"rowsReport", (Object)(this.m_RowsReport.isEmpty() ? "-none-" : this.m_RowsReport.getRange()), (String)"rows: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"colReportNames", (Object)(this.m_ColReportNames.isEmpty() ? "-none-" : this.m_ColReportNames.getIndex()), (String)", names: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"colsReportValues", (Object)(this.m_ColsReportValues.isEmpty() ? "-none-" : this.m_ColsReportValues.getRange()), (String)", value cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"lenient", (boolean)this.m_Lenient, (String)"lenient", (String)", ");
        return result;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        this.m_ColReportNames.setSpreadSheet(sheet);
        int colMeta = this.m_ColReportNames.getIntIndex();
        if (colMeta == -1) {
            throw new IllegalStateException("No column for report names: " + this.m_ColReportNames.getIndex());
        }
        this.m_ColsReportValues.setSpreadSheet(sheet);
        int[] colsValues = this.m_ColsReportValues.getIntIndices();
        if (colsValues.length == 0) {
            throw new IllegalStateException("No columns for report values: " + this.m_ColsReportValues.getRange());
        }
        this.m_RowsReport.setSpreadSheet(sheet);
        int[] rowsMeta = this.m_RowsReport.getIntIndices();
        if (rowsMeta.length == 0) {
            throw new IllegalStateException("No rows for report: " + this.m_RowsReport.getRange());
        }
        ArrayList<Report> result = new ArrayList<Report>();
        for (int i = 0; i < colsValues.length; ++i) {
            try {
                Report report = new Report();
                if (colMeta > -1) {
                    for (int n = 0; n < rowsMeta.length; ++n) {
                        DataRow row = sheet.getRow(rowsMeta[n]);
                        if (!row.hasCell(colsValues[i]) || row.getCell(colsValues[i]).isMissing()) continue;
                        Cell cell = row.getCell(colsValues[i]);
                        if (cell.isNumeric()) {
                            report.setNumericValue(row.getCell(colMeta).getContent(), cell.toDouble().doubleValue());
                            continue;
                        }
                        if (cell.isBoolean()) {
                            report.setBooleanValue(row.getCell(colMeta).getContent(), cell.toBoolean().booleanValue());
                            continue;
                        }
                        report.setStringValue(row.getCell(colMeta).getContent(), cell.getContent());
                    }
                }
                result.add(report);
                continue;
            }
            catch (Exception e) {
                if (this.m_Lenient) {
                    this.getLogger().warning("Failed to process column " + (colsValues[i] + 1) + ":\n" + LoggingHelper.throwableToString((Throwable)e));
                    continue;
                }
                throw e;
            }
        }
        return result.toArray(new Report[0]);
    }
}

