/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.CellRange;
import java.util.Iterator;

public class SpreadSheetMaterializeFormulas
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = -4911635975083212510L;
    protected CellFinder m_Finder;

    public String globalInfo() {
        return "Finds cells with formulas in a spreadsheet and replaces the cell content with the value calculated by the formula.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new CellRange());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setFinder(CellFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public CellFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The cell finder to use.";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        Iterator<CellLocation> cells = this.m_Finder.findCells(result);
        while (cells.hasNext() && !this.m_Stopped) {
            Cell cell;
            CellLocation loc = cells.next();
            if (!result.hasCell(loc.getRow(), loc.getColumn()) || !(cell = result.getCell(loc.getRow(), loc.getColumn())).isFormula()) continue;
            cell.setContent(cell.getContent());
        }
        return result;
    }
}

