/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.LenientModeSupporter;
import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.report.Report;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetRowIndex;
import adams.data.spreadsheet.SpreadSheetRowRange;
import java.util.ArrayList;

public class SpreadSheetRowsToReport
extends AbstractConversion
implements LenientModeSupporter {
    private static final long serialVersionUID = -258589003642261978L;
    protected SpreadSheetRowIndex m_RowReportNames;
    protected boolean m_ReportNamesInHeader;
    protected SpreadSheetRowRange m_RowsReportValues;
    protected SpreadSheetColumnRange m_ColumnsReport;
    protected boolean m_Lenient;

    public String globalInfo() {
        return "Turns spreadsheet rows into report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row-report-names", "rowReportNames", (Object)new SpreadSheetRowIndex());
        this.m_OptionManager.add("report-names-in-header", "reportNamesInHeader", (Object)false);
        this.m_OptionManager.add("rows-report-values", "rowsReportValues", (Object)new SpreadSheetRowRange());
        this.m_OptionManager.add("cols-report", "columnsReport", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("lenient", "lenient", (Object)false);
    }

    public void setRowReportNames(SpreadSheetRowIndex value) {
        this.m_RowReportNames = value;
        this.reset();
    }

    public SpreadSheetRowIndex getRowReportNames() {
        return this.m_RowReportNames;
    }

    public String rowReportNamesTipText() {
        return "The (optional) row that contains the report names.";
    }

    public void setReportNamesInHeader(boolean value) {
        this.m_ReportNamesInHeader = value;
        this.reset();
    }

    public boolean getReportNamesInHeader() {
        return this.m_ReportNamesInHeader;
    }

    public String reportNamesInHeaderTipText() {
        return "Whether the report names are stored in the header.";
    }

    public void setColumnsReport(SpreadSheetColumnRange value) {
        this.m_ColumnsReport = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumnsReport() {
        return this.m_ColumnsReport;
    }

    public String columnsReportTipText() {
        return "The columns that contain report.";
    }

    public void setRowsReportValues(SpreadSheetRowRange value) {
        this.m_RowsReportValues = value;
        this.reset();
    }

    public SpreadSheetRowRange getRowsReportValues() {
        return this.m_RowsReportValues;
    }

    public String rowsReportValuesTipText() {
        return "The rows in the spreadsheet that contain the report values.";
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
        this.reset();
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public String lenientTipText() {
        return "If enabled, then errors (e.g., due to corrupt data) will not cause exceptions.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Report[].class;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"columnsReport", (Object)(this.m_ColumnsReport.isEmpty() ? "-none-" : this.m_ColumnsReport.getRange()), (String)"cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"reportNamesInHeader", (boolean)this.m_ReportNamesInHeader, (String)"SD names in header", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"rowsReportValues", (Object)(this.m_RowsReportValues.isEmpty() ? "-none-" : this.m_RowsReportValues.getRange()), (String)", rows: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"lenient", (boolean)this.m_Lenient, (String)"lenient", (String)", ");
        return result;
    }

    protected Object doConvert() throws Exception {
        HeaderRow rowMetaObj;
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        this.m_RowsReportValues.setSpreadSheet(sheet);
        int[] rowsValues = this.m_RowsReportValues.getIntIndices();
        if (rowsValues.length == 0) {
            throw new IllegalStateException("Failed to locate rows with report values: " + (Object)((Object)this.m_RowsReportValues));
        }
        if (this.m_ReportNamesInHeader) {
            rowMetaObj = sheet.getHeaderRow();
        } else {
            this.m_RowReportNames.setSpreadSheet(sheet);
            int rowMeta = this.m_RowReportNames.getIntIndex();
            if (rowMeta == -1) {
                throw new IllegalStateException("Failed to locate row with report names: " + this.m_RowReportNames.getIndex());
            }
            rowMetaObj = sheet.getRow(rowMeta);
        }
        this.m_ColumnsReport.setSpreadSheet(sheet);
        int[] colsMeta = this.m_ColumnsReport.getIntIndices();
        if (colsMeta.length == 0) {
            throw new IllegalStateException("Failed to locate columns with report: " + this.m_ColumnsReport.getRange());
        }
        ArrayList<Report> result = new ArrayList<Report>();
        for (int i = 0; i < rowsValues.length; ++i) {
            try {
                DataRow row = sheet.getRow(rowsValues[i]);
                Report report = new Report();
                if (rowMetaObj != null) {
                    for (int n = 0; n < colsMeta.length; ++n) {
                        if (!row.hasCell(colsMeta[n]) || row.getCell(colsMeta[n]).isMissing()) continue;
                        Cell cell = row.getCell(colsMeta[n]);
                        if (cell.isNumeric()) {
                            report.setNumericValue(rowMetaObj.getCell(colsMeta[n]).getContent(), cell.toDouble().doubleValue());
                            continue;
                        }
                        if (cell.isBoolean()) {
                            report.setBooleanValue(rowMetaObj.getCell(colsMeta[n]).getContent(), cell.toBoolean().booleanValue());
                            continue;
                        }
                        report.setStringValue(rowMetaObj.getCell(colsMeta[n]).getContent(), cell.getContent());
                    }
                }
                result.add(report);
                continue;
            }
            catch (Exception e) {
                if (this.m_Lenient) {
                    this.getLogger().warning("Failed to process row " + (rowsValues[i] + 1) + ":\n" + LoggingHelper.throwableToString((Throwable)e));
                    continue;
                }
                throw e;
            }
        }
        return result.toArray(new Report[0]);
    }
}

