/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.net.HtmlUtils;
import adams.data.DecimalFormatString;
import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import java.text.DecimalFormat;

public class SpreadSheetStringColumnToDouble
extends AbstractSpreadSheetColumnConverter {
    private static final long serialVersionUID = 8681800940519018023L;
    protected DecimalFormatString m_Format;
    protected transient DecimalFormat m_Formatter;

    public String globalInfo() {
        return "Converts the specified spreadsheet column from string to double, according to the provided format.\nFor more information on the format, see Javadoc of 'java.text.DecimalFormat' class:\n" + HtmlUtils.toJavaApiURL(DecimalFormat.class);
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", (Object)new DecimalFormatString("0.#"));
    }

    @Override
    public String columnTipText() {
        return "The column to convert to double; " + this.m_Column.getExample();
    }

    public void setFormat(DecimalFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DecimalFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format string used for parsing the strings.";
    }

    @Override
    protected void preConvert(SpreadSheet input) {
        super.preConvert(input);
        this.m_Formatter = this.m_Format.toDecimalFormat();
    }

    @Override
    protected void convert(Cell cellOld, Cell cellNew) throws Exception {
        String content = cellOld.getContent();
        if (content.trim().length() > 0) {
            cellNew.setContent(Double.valueOf(this.m_Formatter.parse(content).doubleValue()));
        } else {
            cellNew.setMissing();
        }
    }
}

