/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractSpreadSheetToMatrix;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;

public class SpreadSheetToDoubleMatrix
extends AbstractSpreadSheetToMatrix<Double> {
    private static final long serialVersionUID = 4117708470154504868L;

    public String globalInfo() {
        return "Turns a spreadsheet into a double matrix, using only the numeric columns.";
    }

    public Class generates() {
        return Double[][].class;
    }

    protected Double[][] newMatrix(int rows, int cols) {
        return new Double[rows][cols];
    }

    @Override
    protected boolean includeColumn(SpreadSheet sheet, int col) {
        return sheet.isNumeric(col, true);
    }

    @Override
    protected Double getValue(SpreadSheet sheet, Row row, int col) {
        if (!row.hasCell(col)) {
            return Double.NaN;
        }
        return row.getCell(col).toDouble();
    }
}

