/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetRowIndex;

public class SpreadSheetUseRowAsHeader
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = 2431670205967099683L;
    protected SpreadSheetRowIndex m_Row;
    protected boolean m_ForceString;
    protected boolean m_Delete;

    public String globalInfo() {
        return "Uses the values of the specified data row for the header.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new SpreadSheetRowIndex("1"));
        this.m_OptionManager.add("force-string", "forceString", (Object)false);
        this.m_OptionManager.add("delete", "delete", (Object)false);
    }

    public void setRow(SpreadSheetRowIndex value) {
        this.m_Row = value;
        this.reset();
    }

    public SpreadSheetRowIndex getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row to use as the new header.";
    }

    public void setForceString(boolean value) {
        this.m_ForceString = value;
        this.reset();
    }

    public boolean getForceString() {
        return this.m_ForceString;
    }

    public String forceStringTipText() {
        return "If enabled, the value is set as string, even if it resembles a number.";
    }

    public void setDelete(boolean value) {
        this.m_Delete = value;
        this.reset();
    }

    public boolean getDelete() {
        return this.m_Delete;
    }

    public String deleteTipText() {
        return "If enabled, the row gets deleted after updating the header.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)((Object)this.m_Row), (String)"row: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"forceString", (boolean)this.m_ForceString, (String)"force string", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"delete", (boolean)this.m_Delete, (String)"delete afterwards", (String)", ");
        return result;
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = input;
        if (!this.m_NoCopy) {
            result = result.getClone();
        }
        this.m_Row.setSpreadSheet(input);
        int index = this.m_Row.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Row not found: " + this.m_Row.getIndex());
        }
        HeaderRow header = result.getHeaderRow();
        DataRow row = result.getRow(index);
        for (int i = 0; i < result.getColumnCount(); ++i) {
            if (!row.hasCell(i) || row.getCell(i).isMissing()) {
                header.getCell(i).setMissing();
                continue;
            }
            if (this.m_ForceString) {
                header.getCell(i).setContentAsString(row.getCell(i).getContent());
                continue;
            }
            header.getCell(i).setContent(row.getCell(i).getContent());
        }
        if (this.m_Delete) {
            result.removeRow(index);
        }
        return result;
    }
}

