/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.logging.LoggingHelper;
import adams.data.io.input.AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.NoHeaderSpreadSheetReader;
import adams.data.io.input.WindowedSpreadSheetReader;
import adams.data.io.output.GnumericSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.env.Environment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GnumericSpreadSheetReader
extends AbstractMultiSheetSpreadSheetReaderWithMissingValueSupport
implements NoHeaderSpreadSheetReader,
WindowedSpreadSheetReader {
    private static final long serialVersionUID = -2259236765510690348L;
    public static final String VERSION = "1.10.13";
    protected boolean m_UncompressedInput;
    protected boolean m_NoHeader;
    protected String m_CustomColumnHeaders;
    protected int m_FirstRow;
    protected int m_NumRows;

    public String globalInfo() {
        return "Reads Gnumeric workbook files (GZIP compressed or uncompressed XML), version 1.10.13.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("uncompressed", "uncompressedInput", (Object)false);
        this.m_OptionManager.add("no-header", "noHeader", (Object)false);
        this.m_OptionManager.add("custom-column-headers", "customColumnHeaders", (Object)"");
        this.m_OptionManager.add("first-row", "firstRow", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-rows", "numRows", (Object)-1, (Number)-1, null);
    }

    public void setUncompressedInput(boolean value) {
        this.m_UncompressedInput = value;
        this.reset();
    }

    public boolean getUncompressedInput() {
        return this.m_UncompressedInput;
    }

    public String uncompressedInputTipText() {
        return "If enabled, file is assumed to be uncompressed XML rather than GZIP compressed.";
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
        this.reset();
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, all rows get added as data rows and a dummy header will get inserted.";
    }

    public void setCustomColumnHeaders(String value) {
        this.m_CustomColumnHeaders = value;
        this.reset();
    }

    public String getCustomColumnHeaders() {
        return this.m_CustomColumnHeaders;
    }

    public String customColumnHeadersTipText() {
        return "The custom headers to use for the columns instead (comma-separated list); ignored if empty.";
    }

    public void setFirstRow(int value) {
        if (this.getOptionManager().isValid("firstRow", (Number)value)) {
            this.m_FirstRow = value;
            this.reset();
        }
    }

    public int getFirstRow() {
        return this.m_FirstRow;
    }

    public String firstRowTipText() {
        return "The index of the first row to retrieve (1-based).";
    }

    public void setNumRows(int value) {
        this.m_NumRows = value < 0 ? -1 : value;
        this.reset();
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of data rows to retrieve; use -1 for unlimited.";
    }

    public String getFormatDescription() {
        return "Gnumeric (XML files)";
    }

    public String[] getFormatExtensions() {
        return new String[]{"gnumeric"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new GnumericSpreadSheetWriter();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.STREAM;
    }

    @Override
    protected List<SpreadSheet> doReadRange(InputStream in) {
        ArrayList<SpreadSheet> result = new ArrayList<SpreadSheet>();
        try {
            if (!this.m_UncompressedInput) {
                in = new GZIPInputStream(in);
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            doc.getDocumentElement().normalize();
            NodeList sheetList = doc.getElementsByTagName("gnm:Sheet");
            this.m_SheetRange.setMax(sheetList.getLength());
            int[] indices = this.m_SheetRange.getIntIndices();
            for (int i = 0; i < indices.length; ++i) {
                HeaderRow row;
                Node node;
                int n;
                SpreadSheet sheet = this.m_SpreadSheetType.newInstance();
                sheet.setDataRowClass(this.m_DataRowType.getClass());
                result.add(sheet);
                Node sheetNode = sheetList.item(indices[i]);
                String name = "Sheet" + (indices[i] + 1);
                int rows = -1;
                int cols = -1;
                for (n = 0; n < sheetNode.getChildNodes().getLength(); ++n) {
                    node = sheetNode.getChildNodes().item(n);
                    String nname = node.getNodeName();
                    if ("gnm:Name".equals(nname) || "Name".equals(nname)) {
                        name = node.getTextContent();
                        continue;
                    }
                    if ("gnm:MaxRow".equals(nname) || "MaxRow".equals(nname)) {
                        rows = Integer.parseInt(node.getTextContent()) + 1;
                        continue;
                    }
                    if (!"gnm:MaxCol".equals(nname) && !"MaxCol".equals(nname)) continue;
                    cols = Integer.parseInt(node.getTextContent()) + 1;
                }
                sheet.setName(name);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Sheet: " + name);
                    this.getLogger().info("Rows: " + rows);
                    this.getLogger().info("Cols: " + cols);
                }
                if (cols != -1) {
                    row = sheet.getHeaderRow();
                    if (this.m_NoHeader) {
                        for (String col : SpreadSheetUtils.createHeader((int)cols, (String)this.m_CustomColumnHeaders)) {
                            row.addCell("" + sheet.getColumnCount()).setContentAsString(col);
                        }
                    } else {
                        for (n = 0; n < cols; ++n) {
                            row.addCell("" + n).setContentAsString("Col-" + (n + 1));
                        }
                    }
                }
                int firstRow = this.m_FirstRow - 1;
                int lastRow = this.m_NumRows > 0 ? firstRow + this.m_NumRows - 1 : -1;
                NodeList cellList = ((Element)sheetNode).getElementsByTagName("gnm:Cell");
                for (n = 0; n < cellList.getLength(); ++n) {
                    Node cellNode = cellList.item(n);
                    String type = "60";
                    int cellCol = -1;
                    int cellRow = -1;
                    String content = cellNode.getTextContent();
                    node = cellNode.getAttributes().getNamedItem("ValueType");
                    if (node == null) {
                        node = cellNode.getAttributes().getNamedItem("gnm:ValueType");
                    }
                    if (node != null) {
                        type = node.getTextContent();
                    }
                    if ((node = cellNode.getAttributes().getNamedItem("Col")) == null) {
                        node = cellNode.getAttributes().getNamedItem("gnm:Col");
                    }
                    if (node != null) {
                        cellCol = Integer.parseInt(node.getTextContent());
                    }
                    if ((node = cellNode.getAttributes().getNamedItem("Row")) == null) {
                        node = cellNode.getAttributes().getNamedItem("gnm:Row");
                    }
                    if (node != null) {
                        cellRow = Integer.parseInt(node.getTextContent());
                    }
                    if (cellRow < firstRow || lastRow > -1 && cellRow > lastRow || cellCol == -1 || cellRow == -1) continue;
                    while (sheet.getColumnCount() <= cellCol) {
                        sheet.getHeaderRow().addCell("" + sheet.getColumnCount()).setContent("Col-" + sheet.getColumnCount());
                    }
                    if (this.m_NoHeader) {
                        while (sheet.getRowCount() <= cellRow - firstRow) {
                            sheet.addRow();
                        }
                    } else {
                        while (sheet.getRowCount() < cellRow - firstRow) {
                            sheet.addRow();
                        }
                    }
                    boolean isHeader = false;
                    if (this.m_NoHeader) {
                        row = sheet.getRow(cellRow - firstRow);
                    } else if (cellRow - firstRow == 0) {
                        isHeader = true;
                        row = sheet.getHeaderRow();
                    } else {
                        row = sheet.getRow(cellRow - firstRow - 1);
                    }
                    if (this.m_MissingValue.isMatch(content)) {
                        content = null;
                    }
                    if (content == null) {
                        row.addCell(cellCol).setMissing();
                    } else if (isHeader) {
                        row.addCell(cellCol).setContentAsString(content);
                    } else if (type.equals("40") && content.length() > 0) {
                        row.addCell(cellCol).setContent(Double.valueOf(Double.parseDouble(content)));
                    } else {
                        row.addCell(cellCol).setContent(content);
                    }
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info(SpreadSheetUtils.getCellPosition((int)cellRow, (int)cellCol) + ": " + content);
                }
            }
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to read data!", (Throwable)e);
            this.m_LastError = "Failed to read range '" + this.m_SheetRange + "' from stream!\n" + LoggingHelper.throwableToString((Throwable)e);
        }
        return result;
    }

    public static void main(String[] args) {
        GnumericSpreadSheetReader.runReader(Environment.class, GnumericSpreadSheetReader.class, (String[])args);
    }
}

