/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Properties;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.output.PropertiesSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class PropertiesSpreadSheetReader
extends AbstractSpreadSheetReader {
    private static final long serialVersionUID = -7201569718203967741L;
    public static final String HEADER_KEY = "Key";
    public static final String HEADER_VALUE = "Value";
    protected boolean m_ForceString;

    public String globalInfo() {
        return "Turns Java properties files into spreadsheets with two columns: Key and Value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("force-string", "forceString", (Object)false);
    }

    public void setForceString(boolean value) {
        this.m_ForceString = value;
        this.reset();
    }

    public boolean getForceString() {
        return this.m_ForceString;
    }

    public String forceStringTipText() {
        return "If enabled, the property values are set as string, bypassing the spreadsheet's parsing.";
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new PropertiesSpreadSheetWriter();
    }

    public String getFormatDescription() {
        return "Properties files";
    }

    public String[] getFormatExtensions() {
        return new String[]{"props", "properties"};
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.FILE;
    }

    protected SpreadSheet doRead(File file) {
        Properties props = new Properties();
        if (!props.load(file.getAbsolutePath())) {
            return null;
        }
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("K").setContentAsString(HEADER_KEY);
        row.addCell("V").setContentAsString(HEADER_VALUE);
        ArrayList keys = new ArrayList(props.keySetAll());
        Collections.sort(keys);
        for (String key : keys) {
            row = result.addRow();
            row.addCell("K").setContentAsString(key);
            if (this.m_ForceString) {
                row.addCell("V").setContentAsString(props.getProperty(key));
                continue;
            }
            row.addCell("V").setContent(props.getProperty(key));
        }
        return result;
    }

    public static void main(String[] args) {
        PropertiesSpreadSheetReader.runReader(Environment.class, PropertiesSpreadSheetReader.class, (String[])args);
    }
}

