/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.data.io.input.SimpleStreamSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.logging.Level;

public class SimpleStreamSpreadSheetWriter
extends AbstractSpreadSheetWriter {
    private static final long serialVersionUID = -6342369466120096983L;
    protected boolean m_OmitMissing;

    public String globalInfo() {
        return "Simple stream format for spreadsheets:\n- one spreadsheet row per line in the output\n- cells are separated by TAB\n- cell format: '<1-based index>:<content-type ID>:<content>'\nNB: tabs, new lines etc in the content get backquoted.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("omit-missing", "omitMissing", (Object)false);
    }

    public void setOmitMissing(boolean value) {
        this.m_OmitMissing = value;
        this.reset();
    }

    public boolean getOmitMissing() {
        return this.m_OmitMissing;
    }

    public String omitMissingTipText() {
        return "If enabled, missing cells and ones with missing values are omitted.";
    }

    public String getFormatDescription() {
        return "Simple stream format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"ssf"};
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.WRITER;
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new SimpleStreamSpreadSheetReader();
    }

    protected void writeCell(BufferedWriter writer, int index, Cell cell) throws Exception {
        writer.write("" + (index + 1));
        writer.write(":");
        if (cell == null) {
            writer.write(Cell.ContentType.MISSING.getID());
        } else {
            writer.write(cell.getContentType().getID());
        }
        writer.write(":");
        if (cell == null || cell.isMissing()) {
            writer.write("?");
        } else {
            writer.write(Utils.backQuoteChars((String)cell.getContent()));
        }
    }

    protected boolean writeRow(BufferedWriter writer, SpreadSheet sheet, Row row) {
        boolean result = true;
        try {
            boolean first = true;
            for (int i = 0; i < sheet.getColumnCount(); ++i) {
                if (row.hasCell(i)) {
                    Cell cell = row.getCell(i);
                    if (cell.isMissing()) {
                        if (this.m_OmitMissing) continue;
                        if (!first) {
                            writer.write(9);
                        }
                        this.writeCell(writer, i, cell);
                        first = false;
                        continue;
                    }
                    if (!first) {
                        writer.write(9);
                    }
                    this.writeCell(writer, i, cell);
                    first = false;
                    continue;
                }
                if (this.m_OmitMissing) continue;
                if (!first) {
                    writer.write(9);
                }
                this.writeCell(writer, i, null);
                first = false;
            }
            writer.newLine();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write row: " + row, (Throwable)e);
            result = false;
        }
        return result;
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        BufferedWriter bwriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        boolean result = this.writeRow(bwriter, content, (Row)content.getHeaderRow());
        if (result) {
            for (Row row : content.rows()) {
                if (this.m_Stopped) {
                    return false;
                }
                result = this.writeRow(bwriter, content, row);
                if (result) continue;
                this.getLogger().severe("Failed to write row to writer: " + row);
            }
        }
        return result;
    }
}

