/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.columnfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.AbstractColumnFinder;
import gnu.trove.list.array.TIntArrayList;

public class ByExactName
extends AbstractColumnFinder {
    private static final long serialVersionUID = 2989233908194930918L;
    protected String m_Name;

    public String globalInfo() {
        return "Returns the indices of columns which names match exactly the provided name.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", (Object)"");
    }

    public void setName(String value) {
        this.m_Name = value;
        this.reset();
    }

    public String getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The name to match the attribute names against.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"name", (Object)this.m_Name, (String)"name: ");
    }

    @Override
    protected int[] doFindColumns(SpreadSheet data) {
        TIntArrayList result = new TIntArrayList();
        HeaderRow header = data.getHeaderRow();
        for (int i = 0; i < header.getCellCount(); ++i) {
            if (!this.m_Name.equals(header.getCell(i).getContent())) continue;
            result.add(i);
        }
        return result.toArray();
    }
}

