/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.LookUpHelper;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.MissingLookUpKey;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.transformer.LookUpInit;
import java.util.HashMap;

public class LookUp
extends AbstractSimpleSource {
    private static final long serialVersionUID = -4888807180866059350L;
    protected StorageName m_StorageName;
    protected String m_Key;
    protected MissingLookUpKey m_MissingKey;
    protected String m_MissingValue;
    protected boolean m_UseNative;

    public String globalInfo() {
        return "Forwards the value associated with the given key, using the specified lookup table from internal storage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
        this.m_OptionManager.add("key", "key", (Object)"");
        this.m_OptionManager.add("missing-key", "missingKey", (Object)MissingLookUpKey.NO_OUTPUT);
        this.m_OptionManager.add("missing-value", "missingValue", (Object)"???");
        this.m_OptionManager.add("use-native", "useNative", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)this.m_Key, (String)", key: ");
        if (value != null) {
            result = result + value;
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"missingKey", (Object)((Object)this.m_MissingKey), (String)", missing: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"missingValue", (Object)this.m_MissingValue, (String)", value: ");
        value = QuickInfoHelper.toString((OptionHandler)this, (String)"useNative", (boolean)this.m_UseNative, (String)", native");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the lookup table in the internal storage.";
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The key of the value to output.";
    }

    public void setMissingKey(MissingLookUpKey value) {
        this.m_MissingKey = value;
        this.reset();
    }

    public MissingLookUpKey getMissingKey() {
        return this.m_MissingKey;
    }

    public String missingKeyTipText() {
        return "The behavior in case a lookup key is missing (ie not found in the lookup table).";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The value to forward if the missing key behavior is " + (Object)((Object)MissingLookUpKey.OUTPUT_MISSING_VALUE) + ".";
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are output rather than strings.";
    }

    public Class[] generates() {
        if (this.m_UseNative) {
            return new Class[]{Object.class};
        }
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            HashMap<String, Object> lookup = LookUpHelper.getTable((Actor)this, this.m_StorageName);
            if (lookup.containsKey(this.m_Key)) {
                Object value = lookup.get(this.m_Key);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Lookup: '" + this.m_Key + "' -> '" + value + "'");
                }
                this.m_OutputToken = new Token(value);
            } else {
                switch (this.m_MissingKey) {
                    case NO_OUTPUT: {
                        this.getLogger().severe("Key '" + this.m_Key + "' not available from lookup table '" + this.m_StorageName + "'!");
                        break;
                    }
                    case CAUSE_ERROR: {
                        result = "Key '" + this.m_Key + "' not available from lookup table '" + this.m_StorageName + "'!";
                        break;
                    }
                    case OUTPUT_KEY: {
                        this.m_OutputToken = new Token((Object)this.m_Key);
                        break;
                    }
                    case OUTPUT_MISSING_VALUE: {
                        this.m_OutputToken = new Token((Object)this.m_MissingValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled missing key behavior: " + (Object)((Object)this.m_MissingKey));
                    }
                }
            }
        }
        return result;
    }
}

