/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import adams.parser.LookUpUpdateText;
import java.util.HashMap;

public class LookUpUpdate
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 4182914190162129217L;
    protected SpreadSheetColumnIndex m_KeyColumn;
    protected SpreadSheetColumnIndex m_ValueColumn;
    protected LookUpUpdateText m_Rules;

    public String globalInfo() {
        return "Updates the lookup table (in form of a spreadsheet) that passes through using the specified rules.\nThe rules can contain variables.\n\nThe rules use the following grammar:\n\n" + new adams.parser.LookUpUpdate().getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-column", "keyColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value-column", "valueColumn", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("rules", "rules", (Object)new LookUpUpdateText(""));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"keyColumn", (Object)((Object)this.m_KeyColumn), (String)"key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"valueColumn", (Object)((Object)this.m_ValueColumn), (String)", value: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"rules", (Object)(this.m_Rules.isEmpty() ? "-none-" : Shortening.shortenEnd((String)this.m_Rules.stringValue(), (int)40)), (String)", rules: ");
        return result;
    }

    public void setKeyColumn(SpreadSheetColumnIndex value) {
        this.m_KeyColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getKeyColumn() {
        return this.m_KeyColumn;
    }

    public String keyColumnTipText() {
        return "The index of the column in the spreadsheet to use as key; " + this.m_KeyColumn.getExample();
    }

    public void setValueColumn(SpreadSheetColumnIndex value) {
        this.m_ValueColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getValueColumn() {
        return this.m_ValueColumn;
    }

    public String valueColumnTipText() {
        return "The index of the column in the spreadsheet to use as value; " + this.m_ValueColumn.getExample();
    }

    public void setRules(LookUpUpdateText value) {
        this.m_Rules = value;
        this.reset();
    }

    public LookUpUpdateText getRules() {
        return this.m_Rules;
    }

    public String rulesTipText() {
        return "The rules for updating the lookup table.";
    }

    protected String doExecute() {
        String result = null;
        String rules = this.getRules().getValue();
        rules = this.getVariables().expand(rules);
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_KeyColumn.setData(sheet);
        this.m_ValueColumn.setData(sheet);
        HashMap symbols = adams.parser.LookUpUpdate.spreadsheetToSymbols(sheet, this.m_KeyColumn.getIntIndex(), this.m_ValueColumn.getIntIndex());
        try {
            HashMap updated = adams.parser.LookUpUpdate.evaluate(rules, symbols);
            sheet = adams.parser.LookUpUpdate.updateSpreadSheet(sheet, this.m_KeyColumn.getIntIndex(), this.m_ValueColumn.getIntIndex(), updated);
        }
        catch (Exception e) {
            result = this.handleException("Failed to update lookup table!\nRules:\n" + rules + "\nSymbols:\n" + symbols, e);
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

