/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import org.jfree.data.general.Dataset;

public class MakeJFreeChartDataset
extends AbstractTransformer {
    private static final long serialVersionUID = 4200122170088127638L;
    protected AbstractDatasetGenerator m_Dataset;

    public String globalInfo() {
        return "Generates a JFreeChart dataset from the incoming spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dataset", "dataset", (Object)new DefaultXY());
    }

    public void setDataset(AbstractDatasetGenerator value) {
        this.m_Dataset = value;
        this.reset();
    }

    public AbstractDatasetGenerator getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset generator to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"dataset", (Object)((Object)this.m_Dataset), (String)"dataset: ");
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{Dataset.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            Object dataset = this.m_Dataset.generate(sheet);
            this.m_OutputToken = new Token(dataset);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate dataset!", e);
        }
        return result;
    }
}

