/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class SpreadSheetGetHeaderCell
extends AbstractTransformer {
    private static final long serialVersionUID = 6877755289168511940L;
    protected SpreadSheetColumnIndex m_Column;
    protected String m_Empty;

    public String globalInfo() {
        return "Extracts a single value from a spreadsheet's header.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("col", "column", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("empty", "empty", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_Column = new SpreadSheetColumnIndex();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"empty", (Object)(this.m_Empty.length() > 0 ? this.m_Empty : null), (String)", empty: ");
        if (value != null) {
            result = result + null;
        }
        return result;
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the header cell to retrieve; " + this.m_Column.getExample();
    }

    public void setEmpty(String value) {
        this.m_Empty = value;
        this.reset();
    }

    public String getEmpty() {
        return this.m_Empty;
    }

    public String emptyTipText() {
        return "The value to return in case the header cell is empty.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Column.setSpreadSheet(sheet);
        if (this.m_Column.getIntIndex() == -1) {
            result = "Illegal column index ('" + this.m_Column.getIndex() + "')?";
        } else {
            Cell cell = sheet.getHeaderRow().getCell(this.m_Column.getIntIndex());
            String value = cell == null ? this.m_Empty : (cell.isMissing() ? "?" : cell.getContent());
            this.m_OutputToken = new Token((Object)value);
        }
        return result;
    }
}

