/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multispreadsheetoperation;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.RowIdentifier;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.transformer.multispreadsheetoperation.AbstractMultiSpreadSheetOperation;

public abstract class AbstractIndentifiableRowOperation
extends AbstractMultiSpreadSheetOperation<SpreadSheet> {
    private static final long serialVersionUID = -5056170789277731638L;
    protected SpreadSheetColumnRange m_KeyColumns;
    protected RowIdentifier[] m_Rows;
    protected int[] m_ColIndices;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-columns", "keyColumns", (Object)new SpreadSheetColumnRange(""));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"keyColumns", (Object)((Object)this.m_KeyColumns), (String)"key columns: ");
    }

    @Override
    public int minNumSheetsRequired() {
        return 2;
    }

    @Override
    public int maxNumSheetsRequired() {
        return 2;
    }

    public void setKeyColumns(SpreadSheetColumnRange value) {
        this.m_KeyColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getKeyColumns() {
        return this.m_KeyColumns;
    }

    public String keyColumnsTipText() {
        return "The columns to use as keys for identifying rows in the spreadsheets, if empty the row index is used instead; " + this.m_KeyColumns.getExample();
    }

    @Override
    public Class generates() {
        return SpreadSheet.class;
    }

    protected void initRowLookup(SpreadSheet[] sheets) {
        if (this.m_Rows != null) {
            return;
        }
        this.m_Rows = new RowIdentifier[2];
        this.m_ColIndices = new int[0];
        if (this.m_KeyColumns.getRange().length() != 0) {
            this.m_KeyColumns.setSpreadSheet(sheets[0]);
            this.m_ColIndices = this.m_KeyColumns.getIntIndices();
            this.m_Rows[0] = new RowIdentifier((Range)this.m_KeyColumns);
            this.m_Rows[1] = new RowIdentifier((Range)this.m_KeyColumns);
            this.m_Rows[0].identify(sheets[0]);
            this.m_Rows[1].identify(sheets[1]);
        }
    }

    protected abstract Row performOperation(SpreadSheet var1, Row var2, Row var3);

    protected void generateOutputRow(SpreadSheet output, Row rowDiff) {
        HeaderRow header = output.getHeaderRow();
        DataRow rowNew = output.addRow();
        if (rowDiff != null) {
            for (int n = 0; n < header.getCellCount(); ++n) {
                String key = header.getCellKey(n);
                if (rowDiff.hasCell(key) && !rowDiff.getCell(key).isMissing()) {
                    rowNew.addCell(key).setContent(rowDiff.getCell(key).getContent());
                    continue;
                }
                rowNew.addCell(key).setContent("?");
            }
        }
    }

    @Override
    protected SpreadSheet doProcess(SpreadSheet[] sheets, MessageCollection errors) {
        SpreadSheet result = null;
        this.m_Rows = null;
        String msg = sheets[0].equalsHeader(sheets[0]);
        if (msg != null) {
            errors.add("Spreadsheets not compatible: " + msg);
        }
        if (errors.isEmpty()) {
            result = sheets[0].getHeader();
            this.initRowLookup(sheets);
            if (this.m_ColIndices.length > 0) {
                for (String key : this.m_Rows[0].getKeys()) {
                    DataRow row1 = sheets[0].getRow(((Integer)this.m_Rows[0].getRows(key).get(0)).intValue());
                    DataRow row2 = null;
                    if (this.m_Rows[1].getRows(key) != null) {
                        row2 = sheets[1].getRow(((Integer)this.m_Rows[1].getRows(key).get(0)).intValue());
                    }
                    if (row2 == null) continue;
                    this.generateOutputRow(result, this.performOperation(result, (Row)row1, (Row)row2));
                }
            } else {
                for (int n = 0; n < sheets[0].getRowCount() && n < sheets[1].getRowCount(); ++n) {
                    DataRow row1 = sheets[0].getRow(n);
                    DataRow row2 = sheets[1].getRow(n);
                    this.generateOutputRow(result, this.performOperation(result, (Row)row1, (Row)row2));
                }
            }
        }
        this.m_Rows = null;
        this.m_ColIndices = null;
        return result;
    }
}

