/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multispreadsheetoperation;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.transformer.multispreadsheetoperation.AbstractMultiSpreadSheetOperation;
import java.util.HashSet;
import java.util.Set;

public class CommonIDs
extends AbstractMultiSpreadSheetOperation<SpreadSheet> {
    private static final long serialVersionUID = 3363405805013155845L;
    protected SpreadSheetColumnIndex m_Index;
    protected boolean m_Invert;

    public String globalInfo() {
        return "Extracts the common IDs from two or more spreadsheets.\nMatching sense can be inverted, i.e., the IDs not in common are output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    public void setIndex(SpreadSheetColumnIndex value) {
        this.m_Index = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the column with the IDs in the spreadsheet.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "Whether to invert the matching sense and return the IDs 'not' in common.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)((Object)this.m_Index), (String)"col: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"invert", (boolean)this.m_Invert, (String)"invert", (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    public int minNumSheetsRequired() {
        return 2;
    }

    @Override
    public int maxNumSheetsRequired() {
        return 2;
    }

    @Override
    public Class generates() {
        return SpreadSheet.class;
    }

    @Override
    protected SpreadSheet doProcess(SpreadSheet[] sheets, MessageCollection errors) {
        int i;
        DefaultSpreadSheet result = null;
        Set[] ids = new Set[sheets.length];
        for (i = 0; i < sheets.length; ++i) {
            this.m_Index.setData(sheets[i]);
            if (this.m_Index.getIntIndex() == -1) {
                errors.add("Sheet #" + (i + 1) + " does not have column: " + (Object)((Object)this.m_Index));
            }
            ids[i] = new HashSet(sheets[i].getCellValues(this.m_Index.getIntIndex()));
        }
        if (errors.isEmpty()) {
            HashSet subset = new HashSet(ids[0]);
            for (i = 1; i < sheets.length; ++i) {
                if (this.m_Invert) {
                    subset.removeAll(ids[i]);
                    continue;
                }
                subset.retainAll(ids[i]);
            }
            result = new DefaultSpreadSheet();
            HeaderRow row = result.getHeaderRow();
            row.addCell("I").setContent("ID");
            for (String id : subset) {
                result.addRow().addCell("I").setContentAsString(id);
            }
        }
        return result;
    }
}

