/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multispreadsheetoperation;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.multispreadsheetoperation.AbstractMultiSpreadSheetOperation;
import adams.flow.transformer.spreadsheetmethodmerge.AbstractMerge;
import adams.flow.transformer.spreadsheetmethodmerge.Simple;

public class Merge
extends AbstractMultiSpreadSheetOperation<SpreadSheet> {
    private static final long serialVersionUID = 3778575114133031631L;
    protected AbstractMerge m_MergeMethod;

    public String globalInfo() {
        return "Merges 2 or more spreadsheets into a single spreadsheet, using a selectable merge method.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("method", "mergeMethod", (Object)new Simple());
    }

    public AbstractMerge getMergeMethod() {
        return this.m_MergeMethod;
    }

    public void setMergeMethod(AbstractMerge mergeMethod) {
        this.m_MergeMethod = mergeMethod;
        this.reset();
    }

    public String mergeMethodTipText() {
        return "The method that should be used to perform the merge.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"mergeMethod", (Object)((Object)this.m_MergeMethod), (String)"method: ");
    }

    @Override
    public int minNumSheetsRequired() {
        return 2;
    }

    @Override
    public int maxNumSheetsRequired() {
        return -1;
    }

    @Override
    public Class generates() {
        return SpreadSheet.class;
    }

    @Override
    protected SpreadSheet doProcess(SpreadSheet[] sheets, MessageCollection errors) {
        return this.m_MergeMethod.merge(sheets);
    }
}

