/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheetpreview;

import adams.core.net.HtmlUtils;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.gui.core.BaseHtmlEditorPane;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.spreadsheetpreview.AbstractSpreadSheetPreview;
import java.awt.BorderLayout;
import java.awt.Component;

public class SimpleHTML
extends AbstractSpreadSheetPreview {
    private static final long serialVersionUID = -3455538265861369251L;
    protected SpreadSheetColumnRange m_Columns;
    protected String m_MissingValue;

    public String globalInfo() {
        return "Simply displays the specified columns as HTML.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("missing-value", "missingValue", (Object)"N/A");
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The spreadsheet columns to display.";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The string to use for missing values.";
    }

    @Override
    public AbstractSpreadSheetPreview.AbstractSpreadSheetPreviewPanel generate() {
        SimpleTextPanel result = new SimpleTextPanel();
        result.setColumns(this.m_Columns.getClone());
        result.setMissingValue(this.m_MissingValue);
        return result;
    }

    public static class SimpleTextPanel
    extends AbstractSpreadSheetPreview.AbstractSpreadSheetPreviewPanel {
        private static final long serialVersionUID = -3009467848041701061L;
        protected BaseHtmlEditorPane m_PaneHTML;
        protected SpreadSheetColumnRange m_Columns;
        protected String m_MissingValue;

        protected void initialize() {
            super.initialize();
            this.m_Columns = new SpreadSheetColumnRange("first-last");
        }

        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_PaneHTML = new BaseHtmlEditorPane();
            this.m_PaneHTML.addDefaultHyperlinkListener();
            this.add((Component)new BaseScrollPane((Component)this.m_PaneHTML), "Center");
        }

        public void setColumns(SpreadSheetColumnRange value) {
            this.m_Columns = value;
        }

        public SpreadSheetColumnRange getColumns() {
            return this.m_Columns;
        }

        public void setMissingValue(String value) {
            this.m_MissingValue = value;
        }

        public String getMissingValue() {
            return this.m_MissingValue;
        }

        @Override
        protected String doPreview(SpreadSheet sheet, int[] rows) {
            this.m_PaneHTML.setText("");
            this.m_Columns.setData(sheet);
            int[] cols = this.m_Columns.getIntIndices();
            StringBuilder text = new StringBuilder();
            text.append("<html\n>");
            for (int i = 0; i < rows.length; ++i) {
                if (i > 0) {
                    text.append("<br><br>\n");
                }
                text.append("<table border=\"1\" cellspacing=\"0\">\n");
                DataRow row = sheet.getRow(rows[i]);
                for (int n = 0; n < cols.length; ++n) {
                    text.append("<tr>");
                    text.append("<td valign=\"top\">");
                    text.append("<b>");
                    text.append(sheet.getColumnName(cols[n]));
                    text.append("</b>");
                    text.append("</td>");
                    text.append("<td>");
                    String cell = row.hasCell(cols[n]) && !row.getCell(cols[n]).isMissing() ? row.getCell(cols[n]).getContent() : this.m_MissingValue;
                    text.append(HtmlUtils.convertLines((String)HtmlUtils.toHTML((String)cell), (boolean)true));
                    text.append("</td>");
                    text.append("</tr>\n");
                }
                text.append("</table>\n");
            }
            text.append("</html\n>");
            this.m_PaneHTML.setText(text.toString());
            this.m_PaneHTML.setCaretPosition(0);
            return null;
        }
    }
}

