/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.sources;

import adams.core.MessageCollection;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionUtils;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.FilePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.sources.AbstractSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class FileBrowserSource
extends AbstractSource {
    private static final long serialVersionUID = -4475860171792209905L;
    public static final String KEY_DIRECTORY = "directory";
    public static final String KEY_READER = "reader";
    protected BasePanel m_Widget;
    protected DirectoryChooserPanel m_PanelDirectory;
    protected FilePanel m_PanelFiles;
    protected GenericObjectEditorPanel m_PanelReader;
    protected BaseButton m_ButtonLoad;
    protected SpreadSheet m_Data;
    protected boolean m_IgnoreDirUpdates;

    @Override
    public String getName() {
        return "File browser";
    }

    @Override
    public Component getWidget() {
        if (this.m_Widget == null) {
            this.m_Widget = new BasePanel((LayoutManager)new BorderLayout());
            JPanel panel = new JPanel(new BorderLayout(5, 5));
            this.m_Widget.add((Component)panel, (Object)"Center");
            this.m_PanelDirectory = new DirectoryChooserPanel();
            this.m_PanelDirectory.addChangeListener(e -> {
                if (!this.m_IgnoreDirUpdates) {
                    this.m_PanelFiles.setCurrentDir(((File)this.m_PanelDirectory.getCurrent()).getAbsolutePath());
                }
            });
            panel.add((Component)this.m_PanelDirectory, "North");
            this.m_PanelFiles = new FilePanel(false);
            this.m_PanelFiles.setListDirs(true);
            this.m_PanelFiles.setSearchVisible(true);
            this.m_PanelFiles.addSelectionChangeListener(e -> this.update());
            this.m_PanelFiles.addDirectoryChangeListener(e -> {
                this.m_IgnoreDirUpdates = true;
                this.m_PanelDirectory.setCurrent((File)new PlaceholderFile(this.m_PanelFiles.getCurrentDir()));
                this.m_IgnoreDirUpdates = false;
            });
            panel.add((Component)this.m_PanelFiles, "Center");
            ParameterPanel panelParams = new ParameterPanel();
            this.m_Widget.add((Component)panelParams, (Object)"South");
            this.m_PanelReader = new GenericObjectEditorPanel(SpreadSheetReader.class, (Object)new CsvSpreadSheetReader());
            panelParams.addParameter("Reader", (Component)this.m_PanelReader);
            this.m_ButtonLoad = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
            this.m_ButtonLoad.addActionListener(e -> this.load());
            panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.add((Component)this.m_ButtonLoad);
            panelParams.addParameter("Load", (Component)panel);
        }
        return this.m_Widget;
    }

    protected void load() {
        SwingWorker worker = new SwingWorker(){
            String error;

            protected Object doInBackground() throws Exception {
                FileBrowserSource.this.m_ButtonLoad.setEnabled(false);
                SpreadSheetReader reader = (SpreadSheetReader)FileBrowserSource.this.m_PanelReader.getCurrent();
                File input = FileBrowserSource.this.m_PanelFiles.getSelectedFile();
                try {
                    FileBrowserSource.this.m_Data = reader.read(input);
                    if (FileBrowserSource.this.m_Data == null) {
                        this.error = reader.getLastError();
                    } else {
                        FileBrowserSource.this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_AVAILABLE, "Data loaded from: " + input);
                    }
                }
                catch (Exception e) {
                    this.error = LoggingHelper.handleException((LoggingSupporter)FileBrowserSource.this, (String)("Failed to load data from: " + input), (Throwable)e);
                    FileBrowserSource.this.m_Data = null;
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                FileBrowserSource.this.m_ButtonLoad.setEnabled(true);
                if (this.error != null) {
                    GUIHelper.showErrorMessage((Component)FileBrowserSource.this.m_Widget.getParent(), (String)this.error);
                }
            }
        };
        worker.execute();
    }

    @Override
    public boolean hasData() {
        return this.m_Data != null;
    }

    @Override
    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void setCurrentDirectory(File value) {
        this.m_PanelFiles.setCurrentDir(value.getAbsolutePath());
    }

    public File getCurrentDirectory() {
        return (File)this.m_PanelDirectory.getCurrent();
    }

    public File getCurrentFile() {
        return this.m_PanelFiles.getSelectedFile();
    }

    public void setCurrentReader(SpreadSheetReader reader) {
        this.m_PanelReader.setCurrent((Object)reader);
    }

    public SpreadSheetReader getCurrentReader() {
        return (SpreadSheetReader)this.m_PanelReader.getCurrent();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof FileBrowserSource) {
            FileBrowserSource widget = (FileBrowserSource)other;
            widget.getWidget();
            this.setCurrentDirectory(widget.getCurrentDirectory());
            this.setCurrentReader(widget.getCurrentReader());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_DIRECTORY, this.getCurrentDirectory().getAbsolutePath());
        result.put(KEY_READER, OptionUtils.getCommandLine((Object)this.getCurrentReader()));
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_DIRECTORY)) {
                this.setCurrentDirectory((File)new PlaceholderFile((String)map.get(KEY_DIRECTORY)));
            }
            if (map.containsKey(KEY_READER)) {
                try {
                    this.setCurrentReader((SpreadSheetReader)OptionUtils.forAnyCommandLine(SpreadSheetReader.class, (String)((String)map.get(KEY_READER))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate reader from: " + map.get(KEY_READER));
                }
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    public void update() {
        this.m_ButtonLoad.setEnabled(this.getCurrentFile() != null);
    }
}

