/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.sources;

import adams.core.MessageCollection;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionUtils;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.sources.AbstractSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class FileSource
extends AbstractSource {
    private static final long serialVersionUID = -4475860171792209905L;
    public static final String KEY_INPUT = "input";
    public static final String KEY_READER = "reader";
    protected BasePanel m_Widget;
    protected SpreadSheetFileChooserPanel m_PanelInput;
    protected BaseButton m_ButtonLoad;
    protected SpreadSheet m_Data;

    @Override
    public String getName() {
        return "File";
    }

    @Override
    public Component getWidget() {
        if (this.m_Widget == null) {
            this.m_Widget = new BasePanel((LayoutManager)new BorderLayout());
            ParameterPanel panelParams = new ParameterPanel();
            this.m_Widget.add((Component)panelParams, (Object)"Center");
            this.m_PanelInput = new SpreadSheetFileChooserPanel();
            this.m_PanelInput.addChangeListener(e -> this.update());
            this.m_PanelInput.setUseSaveDialog(false);
            panelParams.addParameter("Input", (Component)((Object)this.m_PanelInput));
            this.m_ButtonLoad = new BaseButton((Icon)GUIHelper.getIcon((String)"run.gif"));
            this.m_ButtonLoad.addActionListener(e -> this.load());
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.add((Component)this.m_ButtonLoad);
            panelParams.addParameter("Load", (Component)panel);
        }
        return this.m_Widget;
    }

    protected void load() {
        SwingWorker worker = new SwingWorker(){
            String error;

            protected Object doInBackground() throws Exception {
                FileSource.this.m_ButtonLoad.setEnabled(false);
                SpreadSheetReader reader = FileSource.this.m_PanelInput.getReader();
                File input = (File)FileSource.this.m_PanelInput.getCurrent();
                try {
                    FileSource.this.m_Data = reader.read(input);
                    if (FileSource.this.m_Data == null) {
                        this.error = reader.getLastError();
                    } else {
                        FileSource.this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_AVAILABLE, "Data loaded from: " + input);
                    }
                }
                catch (Exception e) {
                    this.error = LoggingHelper.handleException((LoggingSupporter)FileSource.this, (String)("Failed to load data from: " + input), (Throwable)e);
                    FileSource.this.m_Data = null;
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                FileSource.this.m_ButtonLoad.setEnabled(true);
                if (this.error != null) {
                    GUIHelper.showErrorMessage((Component)FileSource.this.m_Widget.getParent(), (String)this.error);
                }
            }
        };
        worker.execute();
    }

    @Override
    public boolean hasData() {
        return this.m_Data != null;
    }

    @Override
    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void setCurrentFile(File value) {
        this.m_PanelInput.setCurrent(value);
    }

    public File getCurrentFile() {
        return (File)this.m_PanelInput.getCurrent();
    }

    public void setCurrentReader(SpreadSheetReader reader) {
        this.m_PanelInput.setReader(reader);
    }

    public SpreadSheetReader getCurrentReader() {
        return this.m_PanelInput.getReader();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof FileSource) {
            FileSource widget = (FileSource)other;
            widget.getWidget();
            this.setCurrentFile(widget.getCurrentFile());
            this.setCurrentReader(widget.getCurrentReader());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_INPUT, this.getCurrentFile().getAbsolutePath());
        result.put(KEY_READER, OptionUtils.getCommandLine((Object)this.getCurrentReader()));
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_INPUT)) {
                this.setCurrentFile((File)new PlaceholderFile((String)map.get(KEY_INPUT)));
            }
            if (map.containsKey(KEY_READER)) {
                try {
                    this.setCurrentReader((SpreadSheetReader)OptionUtils.forAnyCommandLine(SpreadSheetReader.class, (String)((String)map.get(KEY_READER))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate reader from: " + map.get(KEY_READER));
                }
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    public void update() {
        this.m_ButtonLoad.setEnabled(!((File)this.m_PanelInput.getCurrent()).isDirectory());
    }
}

