/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.core.CleanUpHandler;
import adams.core.logging.LoggingLevel;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.control.Flow;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.KnownParentSupporter;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetColumnComboBox;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheettable.CellRenderingCustomizer;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.tools.SpreadSheetViewerPanel;
import adams.gui.tools.spreadsheetviewer.MultiPagePane;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SpreadSheetPanel
extends BasePanel
implements SpreadSheetSupporter,
TableModelListener,
CleanUpHandler,
KnownParentSupporter {
    private static final long serialVersionUID = -4251007424174062651L;
    protected MultiPagePane m_Owner;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetColumnComboBox m_ColumnComboBox;
    protected SearchPanel m_PanelSearch;
    protected List<Flow> m_GeneratedFlows;
    protected File m_Filename;
    protected SpreadSheetReader m_Reader;
    protected SpreadSheetWriter m_Writer;

    public SpreadSheetPanel(MultiPagePane owner) {
        this.setOwner(owner);
    }

    protected void initialize() {
        super.initialize();
        this.m_GeneratedFlows = new ArrayList<Flow>();
        this.m_Filename = null;
        this.m_Reader = null;
        this.m_Writer = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Table = new SpreadSheetTable(new SpreadSheetTableModel());
        this.m_Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SpreadSheetPanel.this.getViewer() != null) {
                    SpreadSheetPanel.this.getViewer().getViewerTabs().notifyTabs(SpreadSheetPanel.this);
                }
            }
        });
        this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
        this.m_Table.getModel().addTableModelListener(this);
        JPanel panel = new JPanel(new FlowLayout(2));
        this.m_ColumnComboBox = new SpreadSheetColumnComboBox(this.m_Table);
        JLabel label = new JLabel("Jump to");
        label.setLabelFor((Component)this.m_ColumnComboBox);
        label.setDisplayedMnemonic('J');
        panel.add(label);
        panel.add((Component)this.m_ColumnComboBox);
        this.add(panel, "North");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                SpreadSheetPanel.this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        this.add((Component)this.m_PanelSearch, "South");
    }

    public void setOwner(MultiPagePane value) {
        this.m_Owner = value;
    }

    public MultiPagePane getOwner() {
        return this.m_Owner;
    }

    public Container getKnownParent() {
        return this.getOwner();
    }

    public String getTabTitle() {
        int index;
        String result = null;
        if (this.getOwner() != null && (index = this.getOwner().indexOfPage((Component)((Object)this))) > -1) {
            result = this.getOwner().getTitleAt(index);
        }
        return result;
    }

    public SpreadSheetViewerPanel getViewer() {
        if (this.getOwner() != null) {
            return this.getOwner().getOwner();
        }
        return null;
    }

    public void setNumDecimals(int value) {
        this.m_Table.setNumDecimals(value);
    }

    public int getNumDecimals() {
        return this.m_Table.getNumDecimals();
    }

    public void setCellRenderingCustomizer(CellRenderingCustomizer value) {
        this.m_Table.setCellRenderingCustomizer(value);
    }

    public CellRenderingCustomizer getCellRenderingCustomizer() {
        return this.m_Table.getCellRenderingCustomizer();
    }

    public void setShowFormulas(boolean value) {
        this.m_Table.setShowFormulas(value);
    }

    public boolean getShowFormulas() {
        return this.m_Table.getShowFormulas();
    }

    public void setReadOnly(boolean value) {
        this.m_Table.setReadOnly(value);
    }

    public boolean isReadOnly() {
        return this.m_Table.isReadOnly();
    }

    public void setModified(boolean value) {
        this.m_Table.setModified(value);
    }

    public boolean isModified() {
        return this.m_Table.isModified();
    }

    public void setShowCellTypes(boolean value) {
        this.m_Table.setShowCellTypes(value);
    }

    public boolean getShowCellTypes() {
        return this.m_Table.getShowCellTypes();
    }

    public SpreadSheetTable getTable() {
        return this.m_Table;
    }

    public void setSheet(SpreadSheet value) {
        this.m_Table.getModel().removeTableModelListener(this);
        this.m_Table.setModel((TableModel)new SpreadSheetTableModel(value));
        this.m_Table.getModel().addTableModelListener(this);
    }

    public SpreadSheet getSheet() {
        return this.toSpreadSheet();
    }

    public SpreadSheet toSpreadSheet() {
        return this.m_Table.toSpreadSheet();
    }

    public SpreadSheet toSpreadSheet(TableRowRange range) {
        return this.m_Table.toSpreadSheet(range);
    }

    public void generateChart(AbstractChartGenerator generator) {
        final Flow flow = generator.generate(this.getTabTitle(), this.getSheet());
        flow.setParentComponent((Component)((Object)this));
        SwingWorker worker = new SwingWorker(){
            String msg = null;

            protected Object doInBackground() throws Exception {
                this.msg = flow.setUp();
                if (this.msg != null) {
                    this.msg = "Failed to setup flow for generating chart:\n" + this.msg;
                }
                if (this.msg == null) {
                    this.msg = flow.execute();
                    if (this.msg != null) {
                        this.msg = "Failed to execute flow for generating chart:\n" + this.msg;
                    }
                }
                if (this.msg == null) {
                    flow.wrapUp();
                    if (flow.hasStopMessage()) {
                        this.msg = "Flow execution for generating chart was stopped:\n" + flow.getStopMessage();
                    }
                }
                return this.msg;
            }

            @Override
            protected void done() {
                super.done();
                if (this.msg != null) {
                    GUIHelper.showErrorMessage((Component)((Object)SpreadSheetPanel.this), (String)this.msg);
                    ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, this.msg + "\n");
                    ConsolePanel.getSingleton().append(LoggingLevel.SEVERE, flow.toCommandLine() + "\n");
                    flow.destroy();
                } else {
                    SpreadSheetPanel.this.addGeneratedFlow(flow);
                }
            }
        };
        worker.execute();
    }

    public void addGeneratedFlow(Flow flow) {
        this.m_GeneratedFlows.add(flow);
    }

    public void setFilename(File value) {
        this.m_Filename = value;
    }

    public File getFilename() {
        return this.m_Filename;
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public void setWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.getViewer() != null) {
            this.getViewer().updateMenu();
        }
        if (this.getOwner() != null) {
            this.getOwner().updateCurrentPage();
        }
    }

    public void cleanUp() {
        for (Flow flow : this.m_GeneratedFlows) {
            flow.destroy();
        }
        this.m_GeneratedFlows.clear();
        if (this.m_Reader != null) {
            this.m_Reader.destroy();
        }
        if (this.m_Writer != null) {
            this.m_Writer.destroy();
        }
        this.m_Table.setModel((TableModel)new SpreadSheetTableModel());
    }
}

